module SusanHelperPablo

using ..Ahorn, Maple

@mapdef Entity "SusanHelper/Pablo" Pablo(x::Integer, y::Integer, speed::Number=2, dashes::Integer=1, god::Bool=false, noGrav::Bool=false)


const placements = Ahorn.PlacementDict(
    "Pablo (Susan Helper)" => Ahorn.EntityPlacement(
        Pablo,
        "point",
    )
)


sprite = "objects/waddleBug/front2"


function Ahorn.selection(entity::Pablo)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::Pablo, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end