module JackalHelperDesertDecal

using ..Ahorn, Maple

@mapdef Entity "JackalHelper/DesertDecal" DesertDecal(x::Integer, y::Integer, name::String="cryobot")


const placements = Ahorn.PlacementDict(
   "Desert Decal (Jackal Helper)" => Ahorn.EntityPlacement(
	  DesertDecal,
	  "point"
   )
)

sprite = "JackalHelper/cryobotRainbow"

function Ahorn.selection(entity::DesertDecal)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::DesertDecal, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end

