module ContortHelperSaveDataStorages

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/SaveDataBooleanStorageTrigger" SaveDataBooleanStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::Bool=false,
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/SaveDataIntegerStorageTrigger" SaveDataIntegerStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::Integer=0,
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/SaveDataFloatStorageTrigger" SaveDataFloatStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::Number=0.0,
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/SaveDataStringStorageTrigger" SaveDataStringStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::String="",
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/SessionBooleanStorageTrigger" SessionBooleanStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::Bool=false,
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/SessionIntegerStorageTrigger" SessionIntegerStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::Integer=0,
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/SessionFloatStorageTrigger" SessionFloatStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::Number=0.0,
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/SessionStringStorageTrigger" SessionStringStorage(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	index::String="",
	state::String="",
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Storage Trigger (SaveData, Boolean) (Contort Helper)" => Ahorn.EntityPlacement(
		SaveDataBooleanStorage,
		"rectangle"
	),
	"Storage Trigger (SaveData, Integer) (Contort Helper)" => Ahorn.EntityPlacement(
		SaveDataIntegerStorage,
		"rectangle"
	),
	"Storage Trigger (SaveData, Float) (Contort Helper)" => Ahorn.EntityPlacement(
		SaveDataFloatStorage,
		"rectangle"
	),
	"Storage Trigger (SaveData, String) (Contort Helper)" => Ahorn.EntityPlacement(
		SaveDataStringStorage,
		"rectangle"
	),
	
	"Storage Trigger (Session, Boolean) (Contort Helper)" => Ahorn.EntityPlacement(
		SessionBooleanStorage,
		"rectangle"
	),
	"Storage Trigger (Session, Integer) (Contort Helper)" => Ahorn.EntityPlacement(
		SessionIntegerStorage,
		"rectangle"
	),
	"Storage Trigger (Session, Float) (Contort Helper)" => Ahorn.EntityPlacement(
		SessionFloatStorage,
		"rectangle"
	),
	"Storage Trigger (Session, String) (Contort Helper)" => Ahorn.EntityPlacement(
		SessionStringStorage,
		"rectangle"
	)
)

end