module ContortHelperFreezeTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/FreezeTrigger" FreezeTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	freezeDuration::Number=0.3,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false,

	needed::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Freeze Trigger $(needed ? "(Needed) " : "")(Contort Helper)" => Ahorn.EntityPlacement(
		FreezeTrigger,
		"rectangle",
		Dict{String,Any}(
			"needed" => needed
		)
	) for needed in [true, false]
)

end