module ContortHelperCustomConfettiTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/CustomConfettiTrigger" CustomConfettiTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	audioEvent::String="event:/game/07_summit/checkpoint_confetti",
	amount::Integer=30,
	depth::Integer=-10000,

	textures::String="particles/confetti",
	colors::String="fe2074,205efe,cefe20",
	offsetXMinimum::Number=-3.0,
	offsetXMaximum::Number=3.0,
	offsetYMinimum::Number=-3.0,
	offsetYMaximum::Number=3.0,
	durationMinimum::Number=2.0,
	durationMaximum::Number=4.0,
	fallSpreadMinimum::Number=0.0,
	fallSpreadMaximum::Number=0.0,
	fallSpeedMinimum::Number=20.0,
	fallSpeedMaximum::Number=20.0,
	rotation::Number=4.0,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Custom Confetti Trigger (Node) (Contort Helper)" => Ahorn.EntityPlacement(
		CustomConfettiTrigger,
		"rectangle",
		Dict{String,Any}(),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	),
	"Custom Confetti Trigger (Player) (Contort Helper)" => Ahorn.EntityPlacement(
		CustomConfettiTrigger,
		"rectangle"
	)
)

# CustomConfettiTrigger

Ahorn.nodeLimits(trigger::CustomConfettiTrigger) = 0, 1

Ahorn.editingOptions(entity::CustomConfettiTrigger) = Dict{String,Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"colors" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

end