module ContortHelperTeleportationTarget

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/TeleportationTarget" TeleportationTarget(
	x::Integer,
	y::Integer,

	targetTag::String=""
)

# Placements

const placements = Ahorn.PlacementDict(
	"Teleportation Target ($(uppercase(tag))) (Contort Helper)" => Ahorn.EntityPlacement(
		TeleportationTarget,
		"point",
		Dict{String,Any}(
			"targetTag" => tag
		)
	) for tag in ["t1", "t2", "t3", "t4", "t5"]
)

# TeleportationTarget

function Ahorn.selection(entity::TeleportationTarget)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.teleportationtarget, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.teleportationtarget, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::TeleportationTarget)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.teleportationtarget, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::TeleportationTarget, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.teleportationtarget, 0, 0)

end