module ContortHelperConfettiSpawnZone

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/ConfettiSpawnZone" ConfettiSpawnZone(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultBlockWidth,
	height::Integer=Maple.defaultBlockHeight,

	audioEvent::String="event:/game/07_summit/checkpoint_confetti",
	amount::Integer=30,
	depth::Integer=-10000,

	textures::String="particles/confetti",
	colors::String="fe2074,205efe,cefe20",
	offsetXMinimum::Number=-3.0,
	offsetXMaximum::Number=3.0,
	offsetYMinimum::Number=-3.0,
	offsetYMaximum::Number=3.0,
	durationMinimum::Number=2.0,
	durationMaximum::Number=4.0,
	fallSpreadMinimum::Number=0.0,
	fallSpreadMaximum::Number=0.0,
	fallSpeedMinimum::Number=20.0,
	fallSpeedMaximum::Number=20.0,
	rotation::Number=4.0,

	delaySpawnMinimum::Number=0.25,
	delaySpawnMaximum::Number=0.25,
	amountPerUpdate::Integer=1
)

# Placements

const placements = Ahorn.PlacementDict(
	"Confetti Spawn Zone (Contort Helper)" => Ahorn.EntityPlacement(
		ConfettiSpawnZone,
		"rectangle"
	)
)

# ConfettiSpawnZone

Ahorn.minimumSize(entity::ConfettiSpawnZone) = 8, 8
Ahorn.resizable(entity::ConfettiSpawnZone) = true, true

const color = (0.5, 1.0, 0.3, 0.4)
const outline = (0.6, 1.0, 0.4, 0.6)
const text = "Confetti Spawn Zone"

function Ahorn.selection(entity::ConfettiSpawnZone, room::Maple.Room, node::Int=0)
	x, y = Int(entity.x), Int(entity.y)
	width, height = Int(entity.width), Int(entity.height)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	if isempty(nodes)
		return Ahorn.Rectangle(x, y, width, height)

	else
		res = Ahorn.Rectangle[Ahorn.Rectangle(x, y, width, height)]

		for node in nodes
			nx, ny = Int.(node)

			push!(res, Ahorn.Rectangle(nx, ny, 8, 8))
		end

		return res
	end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnZone, room::Maple.Room)
	if ctx.ptr != C_NULL
		Ahorn.Cairo.save(ctx)

		x, y = Ahorn.position(entity)
		w, h = Int(entity.width), Int(entity.height)
		
		x /= typemax(Int)
		y /= typemax(Int)

		Ahorn.rectangle(ctx, x, y, w, h)
		Ahorn.clip(ctx)

		Ahorn.drawRectangle(ctx, x, y, w, h, color, outline)
		Ahorn.drawCenteredText(ctx, text, x, y, w, h)

		Ahorn.restore(ctx)
	end
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnZone)
	x, y = Int(entity.data["x"]), Int(entity.data["y"])
	width, height = Int(entity.data["width"]), Int(entity.data["height"])
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])
	offsetCenterX, offsetCenterY = floor(Int, width / 2), floor(Int, height / 2)

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, x + offsetCenterX, y + offsetCenterY, nx + 4, ny + 4, outline, headLength=6)
		Ahorn.drawRectangle(ctx, nx, ny, 8, 8, color, outline)
	end
end

Ahorn.editingOptions(entity::ConfettiSpawnZone) = Dict{String, Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"colors" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

end