module ContortHelperBurstEffects

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/BurstEffect" BurstEffect(
	x::Integer,
	y::Integer,

	texture::String="util/displacementcircle",

	burstDuration::Number=1.5,
	coroutineDuration::Number=1.0,

	radiusFrom::Number=0.0,
	radiusTo::Number=50.0,

	alpha::Number=1.0,

	alphaEaser::String="CubeInOut",
	radiusEaser::String="CubeInOut",

	needed::Bool=false
)

@mapdef Entity "ContortHelper/BurstPath" BurstPath(
	x::Integer,
	y::Integer,

	texture::String="util/displacementcircle",

	burstDuration::Number=2.0,
	coroutineDuration::Number=0.15,

	radiusFrom::Number=0.0,
	radiusTo::Number=50.0,

	alpha::Number=1.0,

	alphaEaser::String="CubeInOut",
	radiusEaser::String="CubeInOut",

	moveSpeed::Number=1.181818,
	moveEaser::String="CubeInOut",

	needed::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Burst ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		BurstEffect,
		"rectangle",
		Dict{String,Any}(
			"burstDuration" => burstDuration,
			"coroutineDuration" => coroutineDuration,
			"radiusTo" => radiusTo
		)
	) for (name, burstDuration, coroutineDuration, radiusTo) in Ahorn.ContortHelper.bursteffectvariants
)

for (name, burstDuration, radiusTo) in Ahorn.ContortHelper.burstpathvariants
	placements["Burst ($(name), Path) (Contort Helper)"] = Ahorn.EntityPlacement(
		BurstPath,
		"point",
		Dict{String,Any}(
			"burstDuration" => burstDuration,
			"radiusTo" => radiusTo
		),
		function (entity)
			entity.data["nodes"] = [(Int(entity.data["x"]) + 16, Int(entity.data["y"]))]
		end
	)
end

# BurstEffect

function Ahorn.selection(entity::BurstEffect)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.bursteffect, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.bursteffect, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::BurstEffect)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.bursteffect, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::BurstEffect, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.bursteffect, 0, 0)

Ahorn.editingOptions(entity::BurstEffect) = Dict{String, Any}(
	"alphaEaser" => Ahorn.ContortHelper.easers,
	"radiusEaser" => Ahorn.ContortHelper.easers
)

# BurstPath

Ahorn.nodeLimits(entity::BurstPath) = 1, 1

function Ahorn.selection(entity::BurstPath)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.burstpath, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.burstpath, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::BurstPath)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.burstpath, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::BurstPath, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.burstpath, 0, 0)

Ahorn.editingOptions(entity::BurstPath) = Dict{String, Any}(
	"alphaEaser" => Ahorn.ContortHelper.easers,
	"radiusEaser" => Ahorn.ContortHelper.easers,
	"moveEaser" => Ahorn.ContortHelper.easers
)

end