module JackalCollabHelperFlagBooster
using ..Ahorn, Maple

@mapdef Entity "JackalCollabHelper/FlagBooster" FlagBooster(x::Integer, y::Integer, neo::Bool=false)

const placements = Ahorn.PlacementDict(
   "Rainbow Booster (Jackal Collab Helper)" => Ahorn.EntityPlacement(
        FlagBooster, 
        "point")
)


const sprite = "objects/boosterNeo/boosterNeo00.png"

function getSprite(entity::FlagBooster)
    return sprite
end

function Ahorn.selection(entity::FlagBooster)
    x, y = Ahorn.position(entity)
    sprite = getSprite(entity)

    return Ahorn.getSpriteRectangle(sprite, x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::FlagBooster, room::Maple.Room)
    sprite = getSprite(entity)
    Ahorn.drawSprite(ctx, sprite, 0, 0)
end

end
