module JackalCollabHelperDonkerRefill
using ..Ahorn, Maple

@mapdef Entity "JackalCollabHelper/DonkerRefill" DonkRefill(x::Integer, y::Integer, twoDash::Bool=false, oneUse::Bool=false, singleFolderName::String="refill", doubleFolderName::String="refillTwo")

const placements = Ahorn.PlacementDict(
   "Reskinnable Refill (Jackal Collab Helper)" => Ahorn.EntityPlacement(
        DonkRefill, 
        "point")
)


const sprite = "objects/refill/idle00.png"

function getSprite(entity::DonkRefill)
    return sprite
end

function Ahorn.selection(entity::DonkRefill)
    x, y = Ahorn.position(entity)
    sprite = getSprite(entity)

    return Ahorn.getSpriteRectangle(sprite, x, y)
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::DonkRefill, room::Maple.Room)
    sprite = getSprite(entity)
    Ahorn.drawSprite(ctx, sprite, 0, 0)
end

end
