module ContortHelperScreenWipeTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/ScreenWipeTrigger" ScreenWipeTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	wipeIn::Bool=true,
	hiresSnow::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false,

	needed::Bool=false
)

@mapdef Trigger "ContortHelper/ScreenWipeModifierTrigger" ScreenWipeModifierTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	color::String="White",

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Wipe Trigger ($(wipeIn ? "In" : "Out")$(needed ? ", Needed" : "")) (Contort Helper)" => Ahorn.EntityPlacement(
		ScreenWipeTrigger,
		"rectangle",
		Dict{String,Any}(
			"wipeIn" => wipeIn,
			"needed" => needed,
		)
	) for needed in [true, false], wipeIn in [true, false]
)

placements["Wipe Modifier Trigger (Contort Helper)"] = Ahorn.EntityPlacement(
	ScreenWipeModifierTrigger,
	"rectangle"
)

# ScreenWipeModifierTrigger

Ahorn.editingOptions(entity::ScreenWipeModifierTrigger) = Dict{String,Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

end