module ContortHelperMomentumModifierTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/MomentumModifierTrigger" MomentumModifierTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	modifierX::Number=0.0,
	modifierY::Number=0.0,

	operation::String="Set",

	onlyX::Bool=false,
	onlyY::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/ConditionalMomentumModifierTrigger" ConditionalMomentumModifierTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	modifierX::Number=0.0,
	modifierY::Number=0.0,

	conditionalModifierX::Number=0.0,
	conditionalModifierY::Number=0.0,

	operation::String="Set",
	conditionalOperation::String="EqualTo",

	onlyX::Bool=false,
	onlyY::Bool=false,
	
	conditionalOnlyX::Bool=false,
	conditionalOnlyY::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict()

for (opName, opIntl) in Ahorn.ContortHelper.operations
	placements["Momentum Trigger ('$(opName)') (Contort Helper)"] = Ahorn.EntityPlacement(
		MomentumModifierTrigger,
		"rectangle",
		Dict{String,Any}(
			"operation" => opIntl
		)
	)

	placements["Momentum Trigger ('$(opName)', Conditional) (Contort Helper)"] = Ahorn.EntityPlacement(
		ConditionalMomentumModifierTrigger,
		"rectangle",
		Dict{String,Any}(
			"operation" => opIntl
		)
	)
end

# MomentumModifierTrigger

Ahorn.editingOptions(entity::MomentumModifierTrigger) = Dict{String,Any}(
	"operation" => Ahorn.ContortHelper.operations
)

# ConditionalMomentumModifierTrigger

Ahorn.editingOptions(entity::ConditionalMomentumModifierTrigger) = Dict{String,Any}(
	"operation" => Ahorn.ContortHelper.operations,
	"conditionalOperation" => Ahorn.ContortHelper.conditionals
)

end