module ContortHelperMadelineSpotlightModifierTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/MadelineSpotlightModifierTrigger" MadelineSpotlightModifierTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	color::String="White",
	alpha::Number=1.0,

	startFade::Integer=32,
	endFade::Integer=64,

	easer::String="CubeInOut",
	duration::Number=1.0,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Player Light Trigger ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		MadelineSpotlightModifierTrigger,
		"rectangle",
		Dict{String,Any}(
			"startFade" => startFade,
			"endFade" => endFade
		)
	) for (name, startFade, endFade) in Ahorn.ContortHelper.madelinelightvariants
)

# MadelineSpotlightModifierTrigger

Ahorn.editingOptions(entity::MadelineSpotlightModifierTrigger) = Dict{String,Any}(
	"color" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"easer" => Ahorn.ContortHelper.easers
)

end