module ContortHelperLightOccludeZone

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/LightOccludeZone" LightOccludeZone(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultBlockWidth,
	height::Integer=Maple.defaultBlockHeight,

	alpha::Number=1.0
)

# Placements

const placements = Ahorn.PlacementDict(
	"Light-Occlude Zone (Contort Helper)" => Ahorn.EntityPlacement(
		LightOccludeZone,
		"rectangle"
	)
)

# LightOccludeZone

Ahorn.minimumSize(entity::LightOccludeZone) = 8, 8
Ahorn.resizable(entity::LightOccludeZone) = true, true

const color = (0.6, 0.6, 0.6, 0.4)
const outline = (0.7, 0.7, 0.7, 0.6)
const text = "Light-Occlude Zone"

function Ahorn.selection(entity::LightOccludeZone, room::Maple.Room, node::Int=0)
	x, y = Int(entity.x), Int(entity.y)
	width, height = Int(entity.width), Int(entity.height)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	if isempty(nodes)
		return Ahorn.Rectangle(x, y, width, height)

	else
		res = Ahorn.Rectangle[Ahorn.Rectangle(x, y, width, height)]

		for node in nodes
			nx, ny = Int.(node)

			push!(res, Ahorn.Rectangle(nx, ny, 8, 8))
		end

		return res
	end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::LightOccludeZone, room::Maple.Room)
	if ctx.ptr != C_NULL
		Ahorn.Cairo.save(ctx)

		x, y = Ahorn.position(entity)
		w, h = Int(entity.width), Int(entity.height)
		
		x /= typemax(Int)
		y /= typemax(Int)

		Ahorn.rectangle(ctx, x, y, w, h)
		Ahorn.clip(ctx)

		Ahorn.drawRectangle(ctx, x, y, w, h, color, outline)
		Ahorn.drawCenteredText(ctx, text, x, y, w, h)

		Ahorn.restore(ctx)
	end
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::LightOccludeZone)
	x, y = Int(entity.data["x"]), Int(entity.data["y"])
	width, height = Int(entity.data["width"]), Int(entity.data["height"])
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])
	offsetCenterX, offsetCenterY = floor(Int, width / 2), floor(Int, height / 2)

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, x + offsetCenterX, y + offsetCenterY, nx + 4, ny + 4, outline, headLength=6)
		Ahorn.drawRectangle(ctx, nx, ny, 8, 8, color, outline)
	end
end

end