module ContortHelperLightningStrikesController

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/LightningStrikesController" LightningStrikesController(
	x::Integer,
	y::Integer,

	chanceOfPlayingAudio::Number=1.0,
	audioEvents::String="event:/new_content/game/10_farewell/lightning_strike",
	
	shakeMinimum::Number=0.25,
	shakeMaximum::Number=0.35,
	amountMinimum::Integer=3,
	amountMaximum::Integer=6,
	depth::Integer=-8500,
	
	flashColors::String="ffffff,ffffff,ffffff",
	flashColorAlphaMinimum::Number=0.6,
	flashColorAlphaMaximum::Number=0.8,

	chanceOfUsingFlash::Number=1.0,
	chanceOfFlashOverPlayer::Number=0.1,
	
	secondsToTry::Number=3.0,
	chanceOfOccurring::Number=0.5,
	
	lightningColors::String="ffffff,ffffff,ffffff",
	lightningColorAlphaMinimum::Number=0.8,
	lightningColorAlphaMaximum::Number=1.0,
	lightningThicknessMinimum::Number=0.8,
	lightningThicknessMaximum::Number=1.2,
	lightningSpeedMinimum::Number=0.005,
	lightningSpeedMaximum::Number=0.02,
	
	needed::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Lighting Strikes Controller (Contort Helper)" => Ahorn.EntityPlacement(
		LightningStrikesController
	)
)

# LightningStrikesController

function Ahorn.selection(entity::LightningStrikesController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.lightningstrikescontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.lightningstrikescontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::LightningStrikesController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.lightningstrikescontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::LightningStrikesController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.lightningstrikescontroller, 0, 0)

Ahorn.editingOptions(entity::LightningStrikesController) = Dict{String,Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"flashColors" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"lightningColors" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

end