module ContortHelperConfettiSpawners

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/ConfettiSpawner" ConfettiSpawner(
	x::Integer,
	y::Integer,

	audioEvent::String="event:/game/07_summit/checkpoint_confetti",
	amount::Integer=30,
	depth::Integer=-10000,

	textures::String="particles/confetti",
	colors::String="fe2074,205efe,cefe20",
	offsetXMinimum::Number=-3.0,
	offsetXMaximum::Number=3.0,
	offsetYMinimum::Number=-3.0,
	offsetYMaximum::Number=3.0,
	durationMinimum::Number=2.0,
	durationMaximum::Number=4.0,
	fallSpreadMinimum::Number=0.0,
	fallSpreadMaximum::Number=0.0,
	fallSpeedMinimum::Number=20.0,
	fallSpeedMaximum::Number=20.0,
	rotation::Number=4.0,

	delaySpawn::Number=0.5
)

@mapdef Entity "ContortHelper/ConfettiSpawnerPath" ConfettiSpawnerPath(
	x::Integer,
	y::Integer,

	audioEvent::String="event:/game/07_summit/checkpoint_confetti",
	amount::Integer=30,
	depth::Integer=-10000,

	textures::String="particles/confetti",
	colors::String="fe2074,205efe,cefe20",
	offsetXMinimum::Number=-3.0,
	offsetXMaximum::Number=3.0,
	offsetYMinimum::Number=-3.0,
	offsetYMaximum::Number=3.0,
	durationMinimum::Number=2.0,
	durationMaximum::Number=4.0,
	fallSpreadMinimum::Number=0.0,
	fallSpreadMaximum::Number=0.0,
	fallSpeedMinimum::Number=20.0,
	fallSpeedMaximum::Number=20.0,
	rotation::Number=4.0,

	delaySpawn::Number=0.1,
	
	moveSpeed::Number=1.181818,
	moveEaser::String="CubeInOut"
)

# Placements

const placements = Ahorn.PlacementDict(
	"Confetti Spawner (Contort Helper)" => Ahorn.EntityPlacement(
		ConfettiSpawner
	),
	"Confetti Spawner (Path) (Contort Helper)" => Ahorn.EntityPlacement(
		ConfettiSpawnerPath,
		"point",
		Dict{String,Any}(),
		function (entity)
			entity.data["nodes"] = [(Int(entity.data["x"]) + 16, Int(entity.data["y"]))]
		end
	)
)

# ConfettiSpawner

function Ahorn.selection(entity::ConfettiSpawner)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confettispawner, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confettispawner, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawner)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confettispawner, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawner, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confettispawner, 0, 0)

Ahorn.editingOptions(entity::ConfettiSpawner) = Dict{String, Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"colors" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

# ConfettiSpawnerPath

Ahorn.nodeLimits(entity::ConfettiSpawnerPath) = 0, 1

function Ahorn.selection(entity::ConfettiSpawnerPath)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confettispawnerpath, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.confettispawnerpath, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnerPath)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confettispawnerpath, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::ConfettiSpawnerPath, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.confettispawnerpath, 0, 0)

Ahorn.editingOptions(entity::ConfettiSpawnerPath) = Dict{String, Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"colors" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"moveEaser" => Ahorn.ContortHelper.easers
)

end