
module ContortHelperBurstControllers

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/BurstZoneController" BurstZoneController(
	x::Integer,
	y::Integer,

	textures::String="util/displacementcircle",

	burstDurationMinimum::Number=1.5,
	burstDurationMaximum::Number=1.5,

	coroutineDurationMinimum::Number=0.01,
	coroutineDurationMaximum::Number=0.01,

	radiusFromMinimum::Number=0.0,
	radiusFromMaximum::Number=0.0,

	radiusToMinimum::Number=25.0,
	radiusToMaximum::Number=25.0,

	alphaMinimum::Number=1.0,
	alphaMaximum::Number=1.0,

	alphaEaser::String="CubeInOut",
	radiusEaser::String="CubeInOut",

	amountPerUpdate::Integer=1,

	needed::Bool=false
)

@mapdef Entity "ContortHelper/BurstAttacherController" BurstAttacherController(
	x::Integer,
	y::Integer,

	textures::String="util/displacementcircle",
	attachTo::String="Player",

	burstDurationMinimum::Number=1.5,
	burstDurationMaximum::Number=1.5,

	coroutineDurationMinimum::Number=0.25,
	coroutineDurationMaximum::Number=0.25,

	radiusFromMinimum::Number=0.0,
	radiusFromMaximum::Number=0.0,

	radiusToMinimum::Number=50.0,
	radiusToMaximum::Number=50.0,

	alphaMinimum::Number=1.0,
	alphaMaximum::Number=1.0,

	alphaEaser::String="CubeInOut",
	radiusEaser::String="CubeInOut",

	amountPerUpdate::Integer=1,
	burstAllAtOnce::Bool=false,

	needed::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict()

for (name, burstDuration, coroutineDuration, radiusTo) in Ahorn.ContortHelper.burstzonevariants
	placements["Burst Zone Controller ($(name)) (Contort Helper)"] = Ahorn.EntityPlacement(
		BurstZoneController,
		"point",
		Dict{String,Any}(
			"burstDurationMinimum" => burstDuration,
			"burstDurationMaximum" => burstDuration,
			"coroutineDurationMinimum" => coroutineDuration,
			"coroutineDurationMaximum" => coroutineDuration,
			"radiusToMinimum" => radiusTo,
			"radiusToMaximum" => radiusTo
		)
	)
end

for (name, burstDuration, coroutineDuration, radiusTo) in Ahorn.ContortHelper.burstattachervariants
	placements["Burst Attacher Controller ($(name)) (Contort Helper)"] = Ahorn.EntityPlacement(
		BurstAttacherController,
		"point",
		Dict{String,Any}(
			"burstDurationMinimum" => burstDuration,
			"burstDurationMaximum" => burstDuration,
			"coroutineDurationMinimum" => coroutineDuration,
			"coroutineDurationMaximum" => coroutineDuration,
			"radiusToMinimum" => radiusTo,
			"radiusToMaximum" => radiusTo
		)
	) 
end

# BurstZoneController

function Ahorn.selection(entity::BurstZoneController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.burstcontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.burstcontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::BurstZoneController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.burstcontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::BurstZoneController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.burstcontroller, 0, 0)

Ahorn.editingOptions(entity::BurstZoneController) = Dict{String, Any}(
	"alphaEaser" => Ahorn.ContortHelper.easers,
	"radiusEaser" => Ahorn.ContortHelper.easers
)

# BurstAttacherController

function Ahorn.selection(entity::BurstAttacherController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.burstcontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.burstcontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::BurstAttacherController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.burstcontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::BurstAttacherController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.burstcontroller, 0, 0)

Ahorn.editingOptions(entity::BurstAttacherController) = Dict{String, Any}(
	"attachTo" => Ahorn.ContortHelper.attaches,
	"alphaEaser" => Ahorn.ContortHelper.easers,
	"radiusEaser" => Ahorn.ContortHelper.easers
)

end