local communalHelper = require("mods").requireFromPlugin("libraries.communal_helper")

local connectedDreamBlock = {}

connectedDreamBlock.name = "CommunalHelper/ConnectedDreamBlock"
connectedDreamBlock.fieldInformation = {
    refillCount = {
        fieldType = "integer"
    }
}

function connectedDreamBlock.depth(room, entity)
    return entity.below and 5000 or -11000
end

connectedDreamBlock.placements = {
    {
        name = "normal",
        placementType = "rectangle",
        data = {
            width = 8,
            height = 8,
            featherMode = false,
            dashSpeed = 240.0,
            oneUse = false,
            refillCount = -1,
            below = false,
            quickDestroy = false
        }
    },
    {
        name = "feather",
        placementType = "rectangle",
        data = {
            width = 8,
            height = 8,
            featherMode = true,
            dashSpeed = 240.0,
            oneUse = false,
            refillCount = -1,
            below = false,
            quickDestroy = false
        }
    },
    {
        name = "normal_oneuse",
        placementType = "rectangle",
        data = {
            width = 8,
            height = 8,
            featherMode = false,
            dashSpeed = 240.0,
            oneUse = true,
            refillCount = -1,
            below = false,
            quickDestroy = false
        }
    },
    {
        name = "feather_oneuse",
        placementType = "rectangle",
        data = {
            width = 8,
            height = 8,
            featherMode = true,
            dashSpeed = 240.0,
            oneUse = true,
            refillCount = -1,
            below = false,
            quickDestroy = false
        }
    }
}

function connectedDreamBlock.sprite(room, entity)
    return communalHelper.getCustomDreamBlockSpritesByEntity(entity)
end

return connectedDreamBlock
