local vector2 = require("#microsoft.xna.framework.vector2")
local RumbleTrigger = require("#Celeste.RumbleTrigger")

local function fromRoom(x,y)
    return engine.Scene.LevelOffset + vector2(x, y)
end

local coroutineEntity = monocle.Entity()

local dummy

function onBegin()
    if not getFlag("anxietyWatched") then
        disableMovement()
        local luanet = _G.luanet
	celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_brush_activate"):PlayAnimation("idle")
        setFlag("brushActivated", false)
        setFlag("brushBurst", false)
        setFlag("musicChange", false)

        setMusicLayer(1, 0.0)
        if player.Position.X > 5740 then
            walkTo(5724, false, 0.5)
            player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
        else
            walkTo(5732, false, 0.5)
        end
        wait(0.5)
        player.DummyAutoAnimate = false
        player.Depth = 1000000000
        player.Sprite:Play("duck")
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("paint_pant")
        coroutine.yield(getLevel():ZoomTo(vector2(176, 92), 1.5, 2.2))
        player.Sprite.Scale = vector2(1.4, 0.6)
        player.Depth = 0
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("empty")
        dummy = celeste.BadelineDummy(fromRoom(216,424))
        wait(1)
        engine.Scene.Displacement:AddBurst(player.Position, 0.5, 8, 32, 0.5)
        coroutine.yield(player:CreateSplitParticles())
        playSound("event:/char/badeline/maddy_split", player.Position)
        dummy.Sprite.Scale = vector2(-1, 1)
        engine.Scene:add(dummy)
        coroutine.yield(dummy:FloatTo(fromRoom(240,400), -1, false))
        say("SJ2021_1_PAINT_ANXIETY")
        player.Sprite.Scale = vector2(0.8, 1.2)
        player.Sprite:Play("idle")
        say("SJ2021_1_PAINT_ANXIETY_1")
        player.Sprite:Play("idleB")
        say("SJ2021_1_PAINT_ANXIETY_2")
        coroutine.yield(dummy:FloatTo(fromRoom(237,416), -1, false))
        say("SJ2021_1_PAINT_ANXIETY_3")
        player.DummyAutoAnimate = true
        engine.Scene:add(coroutineEntity)
        wait(0.1)
        
        setMusicLayer(1, 1.0)

        coroutineEntity:add(monocle.Coroutine(dummy:FloatTo(fromRoom(248,403), -1, false)))
        coroutineEntity:add(monocle.Coroutine(walk(16, false)))

        coroutineEntity:add(monocle.Coroutine(say("SJ2021_1_PAINT_ANXIETY_4")))
        --coroutine.yield(dummy:FloatTo(fromRoom(260,392), -1, false))
        dummy:Vanish()
        wait(1)
        
        coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(5648, -1278), 2)))
        player.DummyAutoAnimate = true
        coroutine.yield(walkTo(5810, false, 0.5))
        player.DummyAutoAnimate = false
        setFlag("brushCharge", true)
        player.Sprite:Play("lookUp")
        wait(2)
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_brush_activate"):PlayAnimation("activate")
        playSound("event:/char/badeline/boss_idle_air", player.Position + vector2(20, -20))
        playSound("event:/char/badeline/boss_laser_charge", player.Position + vector2(20, -20))
        setFlag("brushCharge", false)
        wait(0.6)
        playSound("event:/char/badeline/boss_idle_air", player.Position)
        wait(0.1)
        playSound("event:/char/badeline/boss_idle_air", player.Position)
        wait(0.4)
        setFlag("brushBurst", true)
        wait(0.4)
        playSound("event:/char/badeline/boss_laser_fire", player.Position)
        playSound("event:/char/badeline/boss_hug", player.Position + vector2(10, -10))

        setFlag("musicChange", true)

        setFlag("brushActivated", true)
        wait(0.5)
        setFlag("brushBurst", false)
        wait(2)
        coroutine.yield(getLevel():ZoomBack(0.6))
        setFlag("anxietyWatched", true)
        enableMovement()
    end
end

function onEnd(level, wasSkipped)
    getLevel():remove(coroutineEntity)
    if wasSkipped then
        enableMovement()
        player.DummyAutoAnimate = true
        getLevel():remove(coroutineEntity)
        setFlag("brushCharge", false)
        setFlag("brushBurst", false)
        setFlag("brushActivated", true)
        setFlag("anxietyWatched", true)
        getLevel():ZoomBack(0)
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("empty")
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_brush_activate"):PlayAnimation("after")
        if dummy then
            dummy:RemoveSelf()
        end
        player.Depth = 0
        
        setFlag("musicChange", true)
        helpers.setMusicLayer(1, 1.0)

        getLevel():remove(coroutineEntity)
    end
end