--- Showing off callbacks available in the cutscene and brief explanations.
-- You are not required to define anything you aren't using.
-- Leave callbacks global to automatically detect it on c# side.
-- This assumes you know your way around Lua, if you don't then <a href=https://www.lua.org/pil/5.1.html>please consider reading the Lua PIL</a>.
-- <h2>Setting up in map editor</h2>
-- In the case of this cutscene, the filename for the entity field is "Assets/LuaCutscenes/example_cutscene".
-- Please use your own folders for your own cutscenes, like any other Celeste asset collisions can happen.<br>
-- <h2>Using C# in cutscene</h2>
-- Any imports from C# can be done with prefixing # in the require string. For example `local celeste = require("#Celeste")`.<br>
-- Check out helper_functions.lua for examples on C# interaction.
-- @module outside

local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local function setLightingAlpha(n)
  engine.Scene.Lighting.Alpha = n + engine.Scene.BaseLightingAlpha
end

--- Coroutine that does all the cutscene magic.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onBegin()
	local level = getLevel()
	vector = player.Position + vector2(0, 0)

	player.ForceCameraUpdate = true
	disableMovement()
	helpers.walkTo(5680)
	player.DummyAutoAnimate = false
	player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Left")
  player.Sprite:Play("lookUp", false, true)
--add badeline
  badeline = celeste.BadelineDummy(vector2(5676, -992))
	badeline.Sprite.Scale = vector2(1, 1)
	level:Add(badeline)

	helpers.wait(1.75)
	player.ForceCameraUpdate = false
	enableMovement()
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
    -- Skipping cutscenes is rude, you know :/
    if wasSkipped then
		enableMovement()
    end
end

--- Callback for when a player enters the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that entered the trigger.
function onEnter(player)

end

--- Callback for when a player stays in the trigger (once per frame).
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that is staying in the trigger.
function onStay(player)

end

--- Callback for when a player leaves the trigger.
-- Only works as long as the cutscene is running.
-- @tparam #Celeste.Player player The player that exited the trigger.
function onLeave(player)
end