﻿using Celeste;
using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;
using System;

namespace DesertHelper
{
    [CustomEntity("DesertHelper/DesertTrigger")]
    public class DesertTrigger : Trigger
    {
        static float DeathTimer;

        public bool CoolVariable;

        public Player player;
        public DesertTrigger(EntityData data, Vector2 offset)
            : base(data, offset)
        {
        }

        public override void OnEnter(Player player)
        {
            CoolVariable = true;
            DeathTimer = 2.5f;
            SaveData.Instance.Assists.DashMode = Assists.DashModes.Normal;
        }

        public override void OnStay(Player player)
        {
            DeathTimer -= Engine.DeltaTime;
            SaveData.Instance.Assists.DashMode = Assists.DashModes.Normal;
        }

        public override void OnLeave(Player player)
        {
            CoolVariable = false;
            SaveData.Instance.Assists.DashMode = Assists.DashModes.Normal;
        }

        public override void Update()
        {
            base.Update();
            if (DeathTimer <= 0f)
            {
                Crash(player);
            }
        }

        public static void desertJump(On.Celeste.Player.orig_Jump orig, Player self, bool particles, bool playSfx)
        {
            DeathTimer = 2.5f;
            orig(self, particles, playSfx);
        }

        public void Crash(Player player)
        {
            Scene.Tracker.GetEntity<Player>()?.Die(new Vector2(-1f, 0f));
        }

    }
}
