﻿using Celeste.Mod;
using Monocle;
using Celeste;
using System;

namespace BlackHoleHelper
{
    public class Helper : EverestModule
    {
        public static Helper Instance;
        public override Type SettingsType => null;
        public override Type SaveDataType => null;

        public Helper()
        {
            Instance = this;
        }

        public override void Load()
        {
        }

        public override void Unload()
        {
        }

        public void SetStrength(string Strength, bool Snap = false)
        {
            foreach (Backdrop background in (Engine.Scene as Level).Background.Backdrops)
            {
                try
                {
                    BlackholeBG blackhole = background as BlackholeBG;
                    blackhole.NextStrength(Engine.Scene as Level, (BlackholeBG.Strengths)Enum.Parse(typeof(BlackholeBG.Strengths), Strength));
                    if (Snap) blackhole.SnapStrength(Engine.Scene as Level, (BlackholeBG.Strengths)Enum.Parse(typeof(BlackholeBG.Strengths), Strength));
                    blackhole.Update(Engine.Scene);
                    Logger.Log("Blackhole Helper", "Updated blackhole strength to " + ((BlackholeBG.Strengths)blackhole.StrengthMultiplier).ToString());
                }
                catch
                {
                }
            }
        }
    }
}
