﻿using System;
using System.Collections;
using System.Collections.Generic;
using Celeste;
using Celeste.Mod;
using Microsoft.Xna.Framework;
using Monocle;

namespace WobblingDecals
{
    public class WobblingModule : EverestModule
    {
        public static Monocle.SpriteBank SpriteBank;
        // Only one alive module instance can exist at any given time.
        public static WobblingModule Instance;

        public WobblingModule()
        {
            Instance = this;
        }
        // no save data needed
        public override Type SaveDataType => null;

        // If you don't need to store any settings, => null
        public override Type SettingsType
        {
            get
            {
                return null;
            }
        }

        public override void LoadContent(bool firstLoad)
        {
            //FrostTempleModule.SpriteBank = new Monocle.SpriteBank(GFX.Game, "Graphics/FrostHelper/CustomSprites.xml");
        }

        // Set up any hooks, event handlers and your mod in general here.
        // Load runs before Celeste itself has initialized properly.
        public override void Load()
        {
            On.Celeste.Decal.Added += Decal_Added;
        }

        private void Decal_Added(On.Celeste.Decal.orig_Added orig, Decal self, Scene scene)
        {
            if (self.Name.Contains("wobbleDecals"))
            {
                string oldName = self.Name;
                self.Name = "generic/grass_a";
                orig(self, scene);
                self.Name = oldName;
                return;
            }
            orig(self, scene);
        }


        // Optional, initialize anything after Celeste has initialized itself properly.
        public override void Initialize()
        {
        }

        // Unload the entirety of your mod's content, remove any event listeners and undo all hooks.
        public override void Unload()
        {
            On.Celeste.Decal.Added -= Decal_Added;
        }

    }
}
