local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")

function checkmoney(money)
    return save.SaveData:CheckMoney(tonumber(money))
end

--returns a bool, checks if the value [points] is greater than their total points
-- for example, they have 400 points, if value = 390, it returns true, if value is 410 returns false
function checkpoints(points)
    return save.SaveData:CheckPoints(tonumber(points));
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

-- Returns if a flag exists, if it does, returns true, if it doesn't returns false
function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

-- Removes a flag
function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

function onTalk()
	disableMovement()
	math.randomseed(os.time())
	fruitVendor = math.random(1,8)
	
	if os.date("*t").hour < 7 and os.date("*t").hour >= 21 then
		say("CC_Lobby_fruitstand_Closed")
		onEnd()
		endCutscene()
	end
	
	if isflagtrue("quest_orangejuice") then
		say("CC_Lobby_fruitstand_Quest")
		removeflag("quest_orangejuice")
		addflag("quest_apple")
		setFlag("quest_apple",true)
		setFlag("quest_orangejuice",false)
		playSound("event:/game/general/assist_nonsolid_out")
		onEnd()
		endCutscene()
	end
	
	if getFlag("weatherRain") then
		for i=1,8,1 do
			if fruitVendor == i then
				say("CC_Lobby_fruitstand_Rain"..tostring(i))
			end
			i = i + 1
		end
	else
		for i=1,8,1 do
			if fruitVendor == i then
				say("CC_Lobby_fruitstand_Normal"..tostring(i))
			end
			i = i + 1
		end
	end

	fruitanswer = choice ("CC_Lobby_fruitstand_answer1", "CC_Lobby_fruitstand_answer2", "CC_Lobby_fruitstand_answer3")
	if fruitanswer == 1 then -- I want a berry
		say("CC_Lobby_fruitstand_dialog1") -- we ran out of them
	elseif fruitanswer == 2 then -- I want a "shiny, golden berry", please
		if not checkpoints(999) then
				say("CC_Lobby_fruitstand_dialog2B") -- stardew reference
		else
			say("CC_Lobby_fruitstand_dialog2") -- explains rainbows
		end
	elseif fruitanswer == 3 then
			say("CC_Lobby_fruitstand_dialog3") -- ok bye
	end
end

function onEnd()
	enableMovement()
end