local monocle = require("#monocle")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local celeste = require("#celeste")
local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local function makeCoroutine(func)
	return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onTalk()
	disableMovement()
	disableRetry()
	walkTo(53)
	setFlag("playerIsSitting",true)
	wait()
	player.DummyAutoAnimate = false
	player.Sprite:Play("couchSit")
	player.Facing = getEnum("Celeste.Facings", "Left")
	celeste.Audio.SetMusicParam("sitting", 1)
	
	talker:Add(makeCoroutine(sitting))
	while true do
        if (celeste.Input.Jump.Pressed or celeste.Input.DashPressed or celeste.Input.MenuCancel.Pressed or celeste.Input.MenuConfirm.Pressed) then
			goto endAnim
        end
        wait()
    end
	::endAnim::
	player.Sprite:Play("couchGetUp")
	wait(0.56)
end

function sitting()
  while true do
  wait()
  end
end

function onEnd()
	celeste.Audio.SetMusicParam("sitting", 0)
	setFlag("playerIsSitting",false)
	enableMovement()
	enableRetry()
end

