local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local dryad = getEntity("DialogNPC", "Celeste.Mod.DoonvHelper.Entities.")
local foundJungleCabin = getFlag("foundJungleCabin")
local foundUndergroundTemple = getFlag("foundUndergroundTemple")
local foundJungleCabinSaid = getFlag("foundJungleCabinSaid")
local foundUndergroundTempleSaid = getFlag("foundUndergroundTempleSaid")
local killedQueen = getFlag("deadqueen")
local killedQueenSaid = getFlag("killedQueenSaid")
local greeting = 0

function onBegin()
	disableMovement()
	makeUnskippable()
	disableRetry()
	dryad.CutsceneModeEnabled = true
	-- The dryad says hi and you start a dialogue
	playSound("event:/CC/CC_KoseiDiamond/ui_pause")
	greeting = math.random(0,2) -- GREETINGS
	if getFlag("cryoGoldenRun") then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_golden"))
	else
		if getFlag("PartyCenter") then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_party"))
		else
			if getFlag("weatherRain") then
				if greeting == 0 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_greetingsD"))
				elseif greeting == 1 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_greetingsE"))
				elseif greeting == 2 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_greetingsF"))
				end
			elseif greeting == 0 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_greetings"))
			elseif greeting == 1 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_greetingsB"))
			elseif greeting == 2 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_greetingsC"))
			end
		end
	end
	coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue1_1", "CC_KoseiDiamond_dryad_dialogue1_2", "CC_KoseiDiamond_dryad_dialogue1_3", "CC_KoseiDiamond_dryad_dialogue1_4"))
	if luaCutscenesUtils.GetChoice() == 1 then -- Ask for the building
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_1"))
	elseif luaCutscenesUtils.GetChoice() == 2 then -- Guide is worried
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_2"))
		setFlag("dryadIsOk")
	elseif luaCutscenesUtils.GetChoice() == 3 then -- Ask about living here
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_3"))
	elseif luaCutscenesUtils.GetChoice() == 4 then -- Tell her the news
		if (not foundJungleCabin or (foundJungleCabin and foundJungleCabinSaid)) and foundUndergroundTemple and not foundUndergroundTempleSaid and (not killedQueen or (killedQueen and killedQueenSaid)) then -- forgot or temple
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1", "CC_KoseiDiamond_dryad_dialogue2_4_3_1"))
			if luaCutscenesUtils.GetChoice() == 1 then -- if forgot
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
			elseif luaCutscenesUtils.GetChoice() == 2 then -- if temple
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_3_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("foundUndergroundTempleSaid",true)
			end
		elseif foundJungleCabin and (not foundUndergroundTemple or (foundUndergroundTemple and foundUndergroundTempleSaid)) and not foundJungleCabinSaid and (not killedQueen or (killedQueen and killedQueenSaid)) then -- forgot or cabin
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1", "CC_KoseiDiamond_dryad_dialogue2_4_2_1"))
			if luaCutscenesUtils.GetChoice() == 1 then -- if forgot
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
			elseif luaCutscenesUtils.GetChoice() == 2 then -- if cabin
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_2_2"))
				setFlag("foundJungleCabinSaid",true)
			end
		elseif foundJungleCabin and foundUndergroundTemple and not foundJungleCabinSaid and not foundUndergroundTempleSaid and (not killedQueen or (killedQueen and killedQueenSaid)) then -- forgot, cabin or temple
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1", "CC_KoseiDiamond_dryad_dialogue2_4_2_1", "CC_KoseiDiamond_dryad_dialogue2_4_3_1"))
			if luaCutscenesUtils.GetChoice() == 1 then -- if forgot
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
			elseif luaCutscenesUtils.GetChoice() == 2 then -- if cabin
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_2_2"))
				setFlag("foundJungleCabinSaid",true)
			elseif luaCutscenesUtils.GetChoice() == 3 then -- if temple
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_3_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("foundUndergroundTempleSaid",true)
			end
		elseif (not foundJungleCabin or (foundJungleCabin and foundJungleCabinSaid)) and foundUndergroundTemple and not foundUndergroundTempleSaid and killedQueen and not killedQueenSaid then -- forgot, temple or queen
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1", "CC_KoseiDiamond_dryad_dialogue2_4_3_1", "CC_KoseiDiamond_dryad_dialogue2_4_4_1"))
			if luaCutscenesUtils.GetChoice() == 1 then -- if forgot
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
			elseif luaCutscenesUtils.GetChoice() == 2 then -- if temple
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_3_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("foundUndergroundTempleSaid",true)
			elseif luaCutscenesUtils.GetChoice() == 3 then -- if queen
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_4_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("killedQueenSaid",true)
			end
		elseif foundJungleCabin and not foundJungleCabinSaid and (not foundUndergroundTemple or (foundUndergroundTemple and foundUndergroundTempleSaid)) and killedQueen and not killedQueenSaid then -- forgot, cabin or queen
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1", "CC_KoseiDiamond_dryad_dialogue2_4_2_1", "CC_KoseiDiamond_dryad_dialogue2_4_4_1"))
			if luaCutscenesUtils.GetChoice() == 1 then -- if forgot
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
			elseif luaCutscenesUtils.GetChoice() == 2 then -- if cabin
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_2_2"))
				setFlag("foundJungleCabinSaid",true)
			elseif luaCutscenesUtils.GetChoice() == 3 then  -- if queen
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_4_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("killedQueenSaid",true)
			end
		elseif foundJungleCabin and foundUndergroundTemple and killedQueen and not foundJungleCabinSaid and not foundUndergroundTempleSaid and not killedQueenSaid then -- forgot, cabin, temple or queen
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1", "CC_KoseiDiamond_dryad_dialogue2_4_2_1", "CC_KoseiDiamond_dryad_dialogue2_4_3_1", "CC_KoseiDiamond_dryad_dialogue2_4_4_1"))
			if luaCutscenesUtils.GetChoice() == 1 then -- if forgot
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
			elseif luaCutscenesUtils.GetChoice() == 2 then -- if cabin
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_2_2"))
				setFlag("foundJungleCabinSaid",true)
			elseif luaCutscenesUtils.GetChoice() == 3 then -- if temple
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_3_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("foundUndergroundTempleSaid",true)
			elseif luaCutscenesUtils.GetChoice() == 4 then -- if queen
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_4_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("killedQueenSaid",true)
			end
		elseif (not foundJungleCabin or (foundJungleCabin and foundJungleCabinSaid)) and (not foundUndergroundTemple or (foundUndergroundTemple and foundUndergroundTempleSaid)) and killedQueen and not killedQueenSaid then -- forgot or queen
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1", "CC_KoseiDiamond_dryad_dialogue2_4_4_1"))
			if luaCutscenesUtils.GetChoice() == 1 then -- if forgot
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
			elseif luaCutscenesUtils.GetChoice() == 2 then -- if queen
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_4_2"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("killedQueenSaid",true)
			end
		else -- only "forgot"
			coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_1"))
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_dryad_dialogue2_4_1_2"))
		end
	end
	enableMovement()
	enableRetry()
	dryad.CutsceneModeEnabled = false
end