local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")
local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local angler = getEntity("DialogNPC", "Celeste.Mod.DoonvHelper.Entities.")


function onBegin()
	disableMovement()
	makeUnskippable()
	disableRetry()
	angler.CutsceneModeEnabled = true
	math.randomseed(os.time())
	greeting = math.random(0,2)
	playSound("event:/CC/CC_KoseiDiamond/ui_pause")
	AddFish("timesTalkedAngler", 1)
	if not (getFlag("anglerFirstTalk") == true) then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_firstGreeting"))
		setFlag("anglerFirstTalk", true)
		endCutscene()
	elseif not (getFlag("hasPole") or getFlag("goodPole") or getFlag("lavaPole") or getFlag("goldenPole")) then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_nopole"))
		endCutscene()
	else -- GREETINGS
		if getFlag("cryoGoldenRun") then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_golden"))
		else
			if getFlag("PartyCenter") then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_party"))
			else
				if getFlag("weatherRain") then
					if greeting == 0 then
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_rain"))
					elseif greeting == 1 then
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_rainB"))
					elseif greeting == 2 then
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_rainC"))
					end
				elseif greeting == 0 then
					bettersay("Did you know I have almost {#F94A4A}"..tostring(GetFishamount("totalFishesCaught")).. "{#} amazingly awesome fish now!? I hope you bring me more so you're actually a bit useful!")
				elseif greeting == 1 then
					bettersay("Wooow! You've bothered me, like, {#F94A4A}"..tostring(GetFishamount("timesTalkedAngler")).. "{#} times! If I didn't have enough cool fishes, I would be really mad!")
				elseif greeting == 2 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_bothered"))
				end
			end
		end
	end
	coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_chat1", "CC_KoseiDiamond_angler_chat2", "CC_KoseiDiamond_angler_chat3", "CC_KoseiDiamond_angler_chat4", "CC_KoseiDiamond_angler_chat5"))
	if luaCutscenesUtils.GetChoice() == 1 then -- gimme advice
		randomAdvice = math.random(0,8)
		if randomAdvice == 0 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice0"))
		elseif randomAdvice == 1 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice1"))
		elseif randomAdvice == 2 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice2"))
		elseif randomAdvice == 3 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice3"))
		elseif randomAdvice == 4 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice4"))
		elseif randomAdvice == 5 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice5"))
		elseif randomAdvice == 6 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice6"))
		elseif randomAdvice == 7 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice7"))
		elseif randomAdvice == 8 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_advice8"))
		end
		endCutscene()
	end
	
	if luaCutscenesUtils.GetChoice() == 2 then -- request time!
		if getFlag("fishRequest6Complete") then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request7"))
			endCutscene()
			
		elseif getFlag("fishRequest5Complete") then -- quest 6, gives golden pole
			if (GetFishamount("fishOfCthulhu") >=1) and (GetFishamount("jellyfish") >=1) and (GetFishamount("momtrout") >=1) and (GetFishamount("theoVoodooFish") >=1) and (GetFishamount("mutantFlinxfin") >=1) then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request6Complete"))
				playSound("event:/game/06_reflection/supersecret_torch_1")
				setFlag("fishRequest6Complete", true)
				wait(0.1)
				AddFish("fishOfCthulhu", -1)
				AddFish("jellyfish", -1)
				AddFish("momtrout", -1)
				AddFish("theoVoodooFish", -1)
				AddFish("mutantFlinxfin", -1)
				endCutscene()
			end
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request6"))
			endCutscene()
		elseif getFlag("fishRequest4Complete") then -- quest 5, gives sponge
			if (GetFishamount("honeyfin") >=3) and (GetFishamount("beeFish") >=15) then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request5Complete"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("fishRequest5Complete", true)
				wait(0.1)
				AddFish("honeyfin", -3)
				AddFish("beeFish", -15)
				endCutscene()
			end
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request5"))
			endCutscene()
			
		elseif getFlag("fishRequest3Complete") then -- quest 4, gives mana crystal
			if (GetFishamount("cloudfish") >=1) and (GetFishamount("demonicHellfish") >=1) then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request4Complete"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("fishRequest4Complete", true)
				wait(0.1)
				AddFish("cloudfish", -1)
				AddFish("demonicHellfish", -1)
				endCutscene()
			end
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request4"))
			endCutscene()
			
		elseif getFlag("fishRequest2Complete") then -- quest 3, gives lava pole
			if GetFishamount("frostMinnow") >=12 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request3Complete"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("fishRequest3Complete", true)
				wait(0.1)
				AddFish("frostMinnow", -12)
				endCutscene()
			end
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request3"))
			endCutscene()
			
		elseif getFlag("fishRequest1Complete") then -- quest 2, gives plant
			if GetFishamount("anglerFish") >=1 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request2Complete"))
				playSound("event:/game/general/seed_complete_berry")
				setFlag("fishRequest2Complete", true)
				wait(0.1)
				AddFish("anglerFish", -1)
				endCutscene()
			end
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request2"))
			endCutscene()
		else -- quest 1, gives 40 terracoins
			if GetFishamount("seaweed") >=5 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request1Complete"))
				playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
				setFlag("fishRequest1Complete", true)
				if getFlag("Midas") then
					AddFish("terracoins", 80)
				else
					AddFish("terracoins", 40)
				end
				wait(0.1)
				AddFish("seaweed", -5)
				endCutscene()
			end
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_request1"))
			endCutscene()
		end
	end
	
	if luaCutscenesUtils.GetChoice() == 3 then -- trophy time!
--crimson
		if GetFishamount("seekerfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("seekerfishTrophy", true)
			AddFish("seekerfish",-10)
		end
		if GetFishamount("anglerFish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("anglerFishTrophy", true)
			AddFish("anglerFish",-10)
		end
		if GetFishamount("fishOfCthulhu") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("fishOfCthulhuTrophy", true)
			AddFish("fishOfCthulhu",-10)
		end
--ocean
		if GetFishamount("seaweed") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("seaweedTrophy", true)
			AddFish("seaweed",-10)
		end
		if GetFishamount("pleadfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("pleadfishTrophy", true)
			AddFish("pleadfish",-10)
		end
		if GetFishamount("jellyfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("jellyfishTrophy", true)
			AddFish("jellyfish",-10)
		end
--sky
		if GetFishamount("harpyfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("harpyfishTrophy", true)
			AddFish("harpyfish",-10)
		end
		if GetFishamount("cloudfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("cloudfishTrophy", true)
			AddFish("cloudfish",-10)
		end
		if GetFishamount("momtrout") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("momtroutTrophy", true)
			AddFish("momtrout",-10)
		end
--lava
		if GetFishamount("lavaKoi") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("lavaKoiTrophy", true)
			AddFish("lavaKoi",-10)
		end
		if GetFishamount("demonicHellfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("demonicHellfishTrophy", true)
			AddFish("demonicHellfish",-10)
		end
		if GetFishamount("theoVoodooFish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("theoVoodooFishTrophy", true)
			AddFish("theoVoodooFish",-10)
		end
--honey
		if GetFishamount("beeFish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("beeFishTrophy", true)
			AddFish("beeFish",-10)
		end
		if GetFishamount("honeyfin") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("honeyfinTrophy", true)
			AddFish("honeyfin",-10)
		end
		if GetFishamount("goldfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("goldfishTrophy", true)
			AddFish("goldfish",-10)
		end
--ice
		if GetFishamount("frostMinnow") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("frostMinnowTrophy", true)
			AddFish("frostMinnow",-10)
		end
		if GetFishamount("celesteFish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("celesteFishTrophy", true)
			AddFish("celesteFish",-10)
		end
		if GetFishamount("mutantFlinxfin") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("mutantFlinxfinTrophy", true)
			AddFish("mutantFlinxfin",-10)
		end
--special
		if GetFishamount("rainbowAngelfish") >=10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_givetrophy"))
			playSound("event:/new_content/char/madeline/bounce_boost")
			setFlag("rainbowAngelfishTrophy", true)
			AddFish("rainbowAngelfish",-10)
		end
--none
		if (GetFishamount("seekerfish") <10) and (GetFishamount("anglerFish") <10) and (GetFishamount("fishOfCthulhu") <10) and (GetFishamount("seaweed") <10) and (GetFishamount("pleadfish") <10) and (GetFishamount("jellyfish") <10)
		and (GetFishamount("harpyfish") <10) and (GetFishamount("cloudfish") <10) and (GetFishamount("momtrout") <10) and (GetFishamount("lavaKoi") <10) and (GetFishamount("demonicHellfish") <10) and (GetFishamount("theoVoodooFish") <10)
		and (GetFishamount("beeFish") <10) and (GetFishamount("honeyfin") <10) and (GetFishamount("goldfish") <10) and (GetFishamount("frostMinnow") <10) and (GetFishamount("celesteFish") <10) and (GetFishamount("mutantFlinxfin") <10)
		and (GetFishamount("rainbowAngelfish") <10) then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_notrophy"))
		end
		
		endCutscene()
	end
	
	if luaCutscenesUtils.GetChoice() == 4 then -- fishy info
		-- Common
		if GetFishamount("seekerfish") >=1 then
		setFlag("seekerfish",true)
			bettersay("Seekerfish. Current amount: {#F94A4A}"..tostring(GetFishamount("seekerfish")).. "{#}.{n}Lives in: {#F94A4A}Crimson{#}:CC_KoseiDiamond_crimson:. Value: 3.{n}Rarity: {#8686e5}common{#} (60%).")
		setFlag("seekerfish",false)
		end
		if GetFishamount("seaweed") >=1 then
		setFlag("seaweed",true)
			bettersay("Seaweed. Current amount: {#F94A4A}"..tostring(GetFishamount("seaweed")).. "{#}.{n}Lives in: {#F94A4A}Ocean{#}:CC_KoseiDiamond_ocean:. Value: 1.{n}Rarity: {#8686e5}common{#} (71%).")
		setFlag("seaweed",false)
		end
		if GetFishamount("harpyfish") >=1 then
			setFlag("harpyfish",true)
			bettersay("Harpyfish. Current amount: {#F94A4A}"..tostring(GetFishamount("harpyfish")).. "{#}.{n}Lives in: {#F94A4A}Sky{#}:CC_KoseiDiamond_space:. Value: 4.{n}Rarity: {#8686e5}common{#} (67.5%).")
			setFlag("harpyfish",false)
		end
		if GetFishamount("lavaKoi") >=1 then
			setFlag("lavaKoi",true)
			bettersay("Lava koi. Current amount: {#F94A4A}"..tostring(GetFishamount("lavaKoi")).. "{#}.{n}Lives in: {#F94A4A}Underworld{#}:CC_KoseiDiamond_underworld:. Value: 6.{n}Rarity: {#8686e5}common{#} (55%).")
			setFlag("lavaKoi",false)
		end
		if GetFishamount("beeFish") >=1 then
			setFlag("beeFish",true)
			bettersay("Bee fish. Current amount: {#F94A4A}"..tostring(GetFishamount("beeFish")).. "{#}.{n}Lives in: {#F94A4A}Honey{#}:CC_KoseiDiamond_jungle:. Value: 5.{n}Rarity: {#8686e5}common{#} (70%).")
			setFlag("beeFish",false)
		end
		if GetFishamount("frostMinnow") >=1 then
			setFlag("frostMinnow",true)
			bettersay("Frost minnow. Current amount: {#F94A4A}"..tostring(GetFishamount("frostMinnow")).. "{#}.{n}Lives in: {#F94A4A}Ice{#}:CC_KoseiDiamond_snow:. Value: 3.{n}Rarity: {#8686e5}common{#} (55%).")
			setFlag("frostMinnow",false)
		end
		-- Rare
		if GetFishamount("anglerFish") >=1 then
			setFlag("anglerFish",true)
			bettersay("Angler fish. Current amount: {#F94A4A}"..tostring(GetFishamount("anglerFish")).. "{#}.{n}Lives in: {#F94A4A}Crimson{#}:CC_KoseiDiamond_crimson:. Value: 12.{n}Rarity: {#8cf10a}uncommon{#} (28%).")
			setFlag("anglerFish",false)
		end
		if GetFishamount("pleadfish") >=1 then
			setFlag("pleadfish",true)
			bettersay("Pleadfish. Current amount: {#F94A4A}"..tostring(GetFishamount("pleadfish")).. "{#}.{n}Lives in: {#F94A4A}Ocean{#}:CC_KoseiDiamond_ocean:. Value: 8.{n}Rarity: {#8cf10a}uncommon{#} (14%).")
			setFlag("pleadfish",false)
		end
		if GetFishamount("cloudfish") >=1 then
			setFlag("cloudfish",true)
			bettersay("Cloudfish. Current amount: {#F94A4A}"..tostring(GetFishamount("cloudfish")).. "{#}.{n}Lives in: {#F94A4A}Sky{#}:CC_KoseiDiamond_space:. Value: 10.{n}Rarity: {#8cf10a}uncommon{#} (22.5%).")
			setFlag("cloudfish",false)
		end
		if GetFishamount("demonicHellfish") >=1 then
			setFlag("demonicHellfish",true)
			bettersay("Demonic hellfish. Current amount: {#F94A4A}"..tostring(GetFishamount("demonicHellfish")).. "{#}.{n}Lives in: {#F94A4A}Underworld{#}:CC_KoseiDiamond_underworld:. Value: 12.{n}Rarity: {#8cf10a}uncommon{#} (38%).")
			setFlag("demonicHellfish",false)
		end
		if GetFishamount("honeyfin") >=1 then
			setFlag("honeyfin",true)
			bettersay("Honeyfin. Current amount: {#F94A4A}"..tostring(GetFishamount("honeyfin")).. "{#}.{n}Lives in: {#F94A4A}Honey{#}:CC_KoseiDiamond_jungle:. Value: 9.{n}Rarity: {#8cf10a}uncommon{#} (26%).")
			setFlag("honeyfin",false)
		end
		if GetFishamount("celesteFish") >=1 then
			setFlag("celesteFish",true)
			bettersay("Celeste fish. Current amount: {#F94A4A}"..tostring(GetFishamount("celesteFish")).. "{#}.{n}Lives in: {#F94A4A}Ice{#}:CC_KoseiDiamond_snow:. Value: 11.{n}Rarity: {#8cf10a}uncommon{#} (31%).")
			setFlag("celesteFish",false)
		end
		-- Very rare
		if GetFishamount("fishOfCthulhu") >=1 then
			setFlag("fishOfCthulhu",true)
			bettersay("Fish of Cthulhu. Current amount: {#F94A4A}"..tostring(GetFishamount("fishOfCthulhu")).. "{#}.{n}Lives in: {#F94A4A}Crimson{#}:CC_KoseiDiamond_crimson:. Value: 28.{n}Rarity: {#04c3f9}very rare{#} (12%).")
			setFlag("fishOfCthulhu",false)
		end
		if GetFishamount("jellyfish") >=1 then
			setFlag("jellyfish",true)
			bettersay("Jellyfish. Current amount: {#F94A4A}"..tostring(GetFishamount("jellyfish")).. "{#}.{n}Lives in: {#F94A4A}Ocean{#}:CC_KoseiDiamond_ocean:. Value: 25.{n}Rarity: {#04c3f9}very rare{#} (15%).")
			setFlag("jellyfish",false)
		end
		if GetFishamount("momtrout") >=1 then
			setFlag("momtrout",true)
			bettersay("Mom trout. Current amount: {#F94A4A}"..tostring(GetFishamount("momtrout")).. "{#}.{n}Lives in: {#F94A4A}Sky{#}:CC_KoseiDiamond_space:. Value: 32.{n}Rarity: {#04c3f9}very rare{#} (10%).")
			setFlag("momtrout",false)
		end
		if GetFishamount("theoVoodooFish") >=1 then
			setFlag("theoVoodooFish",true)
			bettersay("Theo voodoo fish. Current amount: {#F94A4A}"..tostring(GetFishamount("theoVoodooFish")).. "{#}.{n}Lives in: {#F94A4A}Underworld {#}:CC_KoseiDiamond_underworld:. Value: 32.{n}Rarity: {#04c3f9}very rare{#} (7%).")
			setFlag("theoVoodooFish",false)
		end
		if GetFishamount("goldfish") >=1 then
			setFlag("goldfish",true)
			bettersay("Goldfish. Current amount: {#F94A4A}"..tostring(GetFishamount("goldfish")).. "{#}.{n}Lives in: {#F94A4A}Honey{#}:CC_KoseiDiamond_jungle:. Value: 50.{n}Rarity: {#04c3f9}very rare{#} (4%).")
			setFlag("goldfish",false)
		end
		if GetFishamount("mutantFlinxfin") >=1 then
			setFlag("mutantFlinxfin",true)
			bettersay("Mutant flinxfin. Current amount: {#F94A4A}"..tostring(GetFishamount("mutantFlinxfin")).. "{#}.{n}Lives in: {#F94A4A}Ice{#}:CC_KoseiDiamond_snow:. Value: 30.{n}Rarity: {#04c3f9}very rare{#} (14%).")
			setFlag("mutantFlinxfin",false)
		end
		-- Legendary
		if GetFishamount("rainbowAngelfish") >=1 then
			setFlag("rainbowAngelfish",true)
			bettersay("Rainbow angelfish. Current amount: {#F94A4A}"..tostring(GetFishamount("rainbowAngelfish")).. "{#}.{n}Lives in: {#F94A4A}Everywhere{#}:CC_KoseiDiamond_forest:. Value: 100.{n}Rarity: {#b227fd}legendary{#} (-4%).")
			setFlag("rainbowAngelfish",false)
		end
--		if (GetFishamount("seekerfish") <1) and (GetFishamount("anglerFish") <1) and (GetFishamount("fishOfCthulhu") <1) and (GetFishamount("seaweed") <1) and (GetFishamount("pleadfish") <1) and (GetFishamount("jellyfish") <1)
--		and (GetFishamount("harpyfish") <1) and (GetFishamount("cloudfish") <1) and (GetFishamount("momtrout") <1) and (GetFishamount("lavaKoi") <1) and (GetFishamount("demonicHellfish") <1) and (GetFishamount("theoVoodooFish") <1)
--		and (GetFishamount("beeFish") <1) and (GetFishamount("honeyfin") <1) and (GetFishamount("goldfish") <1) and (GetFishamount("frostMinnow") <1) and (GetFishamount("celesteFish") <1) and (GetFishamount("mutantFlinxfin") <1)
--		and (GetFishamount("rainbowAngelfish") <1) then
		if (GetFishamount("totalFishesCaught")) <1 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_nevercaughtfish"))
		end
		endCutscene()
	end
	
	if luaCutscenesUtils.GetChoice() == 5 then -- bye stupid ass
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_angler_chat5answer"))
		endCutscene()
	end
end

-- Adds a fish with any name, if that fish already exists, adds that many of it
function AddFish(name, amount)
    save.SaveData:AddFish(name, tonumber(amount))
 end
-- Returns how many fish of that type you have
function GetFishamount(name)
    return tonumber(save.SaveData:GetFishAmount(name))
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

function onEnd()
	enableMovement()
	enableRetry()
	angler.CutsceneModeEnabled = false
end