-- NOTES:

-- Picks dash upgrade > flash > spawn and despawn 3 decals (dreamers)

-- [after upgrade animation > play CC_XELKHK_CUTS_GP_A, flash white screen  > screenshake throughout rest of cutscene >
-- spawn particles+LurienIdle, spawn particles +MonomonIdle, spawn particles + HerrahIdle (look up video to see where they’re located).
-- Flag toggle on dreamer particle styleground > wait > whiteout > despawn dreamers

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
	return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function dashCutsceneIfUpgradeCollected() -- checks if the upgrade has finished its collection on every frame
	while not getFlag("MothwingCloak") do
		wait()
		disableMovement()
	end
	-- when MothwingCloak is true, do the thing
	disableMovement()
	disableRetry()
	coroutine.yield(getLevel():ZoomTo(vector2(168, 80), 1.125, 0.5))
	--getLevel().InCutscene = true -- cutscene can be skipped from now on
	setFlag("whiteFade",true)
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamEssenceCollect",player.Position)
	wait(0.2)
	shake(vector2(0,0),3)
	wait(0.25)
	setFlag("whiteFade",false)
	wait(0.1)
	-- Lurien
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamGhostAppear",player.Position)
	setFlag("DashCutscene_LurienParticles",true)
	wait(0.2)
	setFlag("DashCutscene_LurienIdle",true)
	wait(1)
	setFlag("DashCutscene_LurienParticles",false)
	-- Monomon
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamGhostAppear",player.Position)
	setFlag("DashCutscene_MonomonParticles",true)
	wait(0.2)
	setFlag("DashCutscene_MonomonIdle",true)
	wait(1)
	setFlag("DashCutscene_MonomonParticles",false)
	-- Herrah
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamGhostAppear",player.Position)
	setFlag("DashCutscene_HerrahParticles",true)
	wait(0.2)
	setFlag("DashCutscene_HerrahIdle",true)
	wait(1)
	setFlag("DashCutscene_HerrahParticles",false)
	say("CC_XELKHK_CUTS_GP_A")
	-- WhiteOut
	setFlag("whiteFade",true)
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamEssenceCollect",player.Position)
	wait(0.2)
	setFlag("DashCutscene_LurienIdle",false)
	setFlag("DashCutscene_MonomonIdle",false)
	setFlag("DashCutscene_HerrahIdle",false)
	wait(0.25)
	setFlag("whiteFade",false)
	coroutine.yield(getLevel():ZoomAcross(vector2(292,886), 1, 0.5))
	enableMovement()
	endCutscene()
end

function onBegin()
	disableMovement()
	makeUnskippable()
	disableRetry()
	player:Add(makeCoroutine(dashCutsceneIfUpgradeCollected))
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		setFlag("whiteFade",false)
		setFlag("DashCutscene_LurienIdle",false)
		setFlag("DashCutscene_MonomonIdle",false)
		setFlag("DashCutscene_HerrahIdle",false)
		setFlag("DashCutscene_LurienParticles",false)
		setFlag("DashCutscene_MonomonParticles",false)
		setFlag("DashCutscene_HerrahParticles",false)
		getLevel():ResetZoom()
	end
	enableRetry()
	enableMovement()
end