local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")

local function dash(xVector, yVector)
  player.OverrideDashDirection = vector2(xVector, yVector)
  setPlayerState(2)
  wait(0.6)
  setPlayerState(11)
  player.OverrideDashDirection = nil
end

function onTalk()
  local hastalk = getFlag("MetMafia")
  local mafiadead = getFlag("KilledMafia")

  disableMovement()
  makeUnskippable ()
  disablePause()


  if mafiadead then
    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_NoMafia"))
  else
      walkTo(-6810)
      setFlag("MafiaZoom", true)
      local level = getLevel()
      coroutine.yield(level:ZoomTo(vector2(160, 115), 2, 0.625))
    if not hastalk then
      setFlag("MetMafia", true)
      coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_FirstTime"))
    else
      setFlag("MetMafia", true)
      coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Start"))
  end
      setFlag("HasAskedMafia", false)
      choiceDialog({
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_WhoAreYou",
              repeatable = true,
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_TalkWhoAreYou"))
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Tracker",
              repeatable = true,
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_TalkTracker"))
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_General",
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  choiceDialog({
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_General_Pons",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_General_TalkPons"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_General_Bells",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_General_TalkBells"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_General_LevelSelect",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_General_TalkLevelSelect"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_General_Deathwish",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_General_TalkDeathwish"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Finished",
                          onChosen = function ()
                              local level = getLevel()
                              coroutine.yield(level:ZoomBack(0.5))
                              closeChoiceDialog()
                          end
                      }
                  })
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements",
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  choiceDialog({
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_FindRift",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_TalkFindRift"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_IncompatibleCollectable",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_TalkIncompatibleCollectableNew"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_SpeedrunRoute",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_TalkSpeedrunRoute"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_Egg",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_TalkEgg"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_TheDepths",
                          repeatable = true,
                          requires = function ()
                              return getFlag("CrossoverCollab_Flamecrafter113_TemporalRift_Cassette")
                          end,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_TalkTheDepths"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_Secret",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Achievements_TalkSecret"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Finished",
                          onChosen = function ()
                              local level = getLevel()
                              coroutine.yield(level:ZoomBack(0.5))
                              closeChoiceDialog()
                          end
                      }
                  })
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse",
              requires = function ()
                  return getFlag("CollapseAttempted")
              end,
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  choiceDialog({
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_MainClear",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_TalkMainClear"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_MainBonus",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_TalkMainBonus"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_TimeLeft",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_TalkTimeLeft"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_FullClear",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_TalkFullClear"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_FloppyDisk",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_TalkFloppyDisk"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_NoBells",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Collapse_TalkNoBells"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Finished",
                          onChosen = function ()
                              local level = getLevel()
                              coroutine.yield(level:ZoomBack(0.5))
                              closeChoiceDialog()
                          end
                      }
                  })
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning",
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  choiceDialog({
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_Main",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkMain"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_CornerBoosts",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkCornerBoosts"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_Balloons",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkBalloons"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_ZipMovers",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkZipMovers"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_Bells",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkBells"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_Pons",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkPons"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_ExtraRoutes",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkExtraRoutes"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_DummySkip",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Speedrunning_TalkDummySkip"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Finished",
                          onChosen = function ()
                              local level = getLevel()
                              coroutine.yield(level:ZoomBack(0.5))
                              closeChoiceDialog()
                          end
                      }
                  })
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle",
              requires = function ()
                  return getFlag("CandleAttempted")
              end,
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  choiceDialog({
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_Main",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_TalkMain"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_Refills",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_TalkRefills"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_Pons",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_TalkPons"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_FloppyDisk",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_TalkFloppyDisk"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_Speed",
                          repeatable = true,
                          onChosen = function ()
                              coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_Candle_TalkSpeed"))
                          end
                      },
                      {
                          "CC_Flamecrafter113_TemporalRift_MafiaHints_Finished",
                          onChosen = function ()
                              local level = getLevel()
                              coroutine.yield(level:ZoomBack(0.5))
                              closeChoiceDialog()
                          end
                      }
                  })
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_BSide",
              requires = function ()
                  return getFlag("CrossoverCollab_Flamecrafter113_TemporalRift_Cassette")
              end,
              repeatable = true,
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("Curse Casual", "CC_Flamecrafter113_TemporalRift_MafiaHints_TalkBSide"))
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Mierder",
              onChosen = function ()
                  setFlag("HasAskedMafia", true)
                  local level = getLevel()
                  coroutine.yield(level:ZoomBack(0.125))
                  dash(1,0)
                  closeChoiceDialog()
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Nevermind",
              requires = function ()
                  return getFlag("HasAskedMafia") == false
              end,
              onChosen = function ()
                  local level = getLevel()
                  coroutine.yield(level:ZoomBack(0.5))
                  closeChoiceDialog()
              end
          },
          {
              "CC_Flamecrafter113_TemporalRift_MafiaHints_Finished",
              requires = function ()
                  return getFlag("HasAskedMafia")
              end,
              onChosen = function ()
                  local level = getLevel()
                  coroutine.yield(level:ZoomBack(0.5))
                  closeChoiceDialog()
              end
          }
      })
  end
end

function onEnd()
  setFlag("MafiaZoom", false)
  enableMovement()
  enablePause()
end