module JackalHelperInsightPuzzle

using ..Ahorn, Maple

@mapdef Entity "JackalHelper/InsightPuzzle" InsightPuzzle(x::Integer, y::Integer)


const placements = Ahorn.PlacementDict(
   "Insight Puzzle (Jackal Helper)" => Ahorn.EntityPlacement(
	  InsightPuzzle,
	  "point"
   )
)

sprite = "scenery/memorial/memorial"

function Ahorn.selection(entity::InsightPuzzle)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::InsightPuzzle, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end

