local vector2 = require("#microsoft.xna.framework.vector2")
local lua_helper = require("#Celeste.Mod.LuaCutscenes.LuaHelper")
local monocle = require("#monocle")

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local coroutineEntity = monocle.Entity()

local function walkBackAndForth()
  -- this 'mini cutscene' runs forever, and causes the player to walk back and forth
  -- it will be cancelled by calling Cancel on its Coroutine instance; it's OK that the function never actually ends
  while true do
    walk(16)
    wait(0.5)
    walk(-16)
    wait(0.5)
  end
end

local walkBackAndForthCoroutine


function onBegin()
    disableMovement()
    setFlag("MaxAlGimmickIntroDone", true)
    player.ForceCameraUpdate = true
    wait(1.0)
    say("MrSwordMaxAlGimmickIntro1")
    engine.Scene:add(coroutineEntity)
    -- coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(1468, 106), 1, 1))) Use to zoom to a specific screen coord, maybe useful later
    walkTo(-80, false, 1.5)

    coroutineEntity:add(monocle.Coroutine(say("MrSwordMaxAlGimmickIntro2")))
    walkBackAndForthCoroutine = makeCoroutine(walkBackAndForth)
    cutsceneEntity:Add(walkBackAndForthCoroutine)
    say("MrSwordMaxAlGimmickIntro3")

    if walkBackAndForthCoroutine then
        walkBackAndForthCoroutine:Cancel()
        cutsceneEntity:Remove(walkBackAndForthCoroutine)
    end
    walkTo(-40, false, 1.5)
    say("MrSwordMaxAlGimmickIntro4")
    walkTo(-10, false, 1.5)
    setFlag("MaxAlGimmickIntroShake", true)
    wait(0.4)
    setFlag("MaxAlGimmickIntroDone", false)
    say("MrSwordMaxAlGimmickIntro5")
    enableMovement()
    player.ForceCameraUpdate = false
    teleportTo(-2,1495,"Looptutorial","Fall")
    endCutscene()
end


function onEnd(level, wasSkipped)

    if wasSkipped then
        teleportTo(-2,1495,"Looptutorial","Fall")
    end
end

