local PersistenceHelperGlamNetuneToggle = {}

PersistenceHelperGlamNetuneToggle.name = "PersistenceHelper/GlamNetuneToggle"
PersistenceHelperGlamNetuneToggle.depth = 2000

function PersistenceHelperGlamNetuneToggle.texture(room, entity)
    local onlyIce = entity.onlyIce
    local onlyFire = entity.onlyFire

    if onlyIce then
        return "objects/sunsetquasar/PersistenceHelper/coreFlipSwitch/switch13"

    elseif onlyFire then
        return "objects/sunsetquasar/PersistenceHelper/coreFlipSwitch/switch15"

    else
        return "objects/sunsetquasar/PersistenceHelper/coreFlipSwitch/switch01"
    end
end

PersistenceHelperGlamNetuneToggle.placements = {
    {
        name = "both",
        data = {
            onlyIce = false,
            onlyFire = false,
            persistent = false
        },
    },
    {
        name = "fire",
        data = {
            onlyIce = false,
            onlyFire = true,
            persistent = false
        },
    },
    {
        name = "ice",
        data = {
            onlyIce = true,
            onlyFire = false,
            persistent = false
        },
    }
}

return PersistenceHelperGlamNetuneToggle