local drawableSprite = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")
local PersistenceHelperCorePuffer = {}

PersistenceHelperCorePuffer.name = "PersistenceHelper/CorePuffer"
PersistenceHelperCorePuffer.depth = 0
PersistenceHelperCorePuffer.placements = {
    {
        name = "left",
        data = {
            right = false,
            notCoreMode = false,
            static = false,
            glamFreezeFrames = false,
        }
    },
    {
        name = "right",
        data = {
            right = true,
            notCoreMode = false,
            static = false,
            glamFreezeFrames = false,
        }
    }
}

function PersistenceHelperCorePuffer.texture(room, entity)
    local tex = entity.notCoreMode and "objects/sunsetquasar/PersistenceHelper/puffer/glam/idle00" or "objects/sunsetquasar/PersistenceHelper/puffer/netune/idle00"
    return tex
end

function PersistenceHelperCorePuffer.scale(room, entity)
    local right = entity.right

    return right and 1 or -1, 1
end

function PersistenceHelperCorePuffer.flip(room, entity, horizontal, vertical)
    if horizontal then
        entity.right = not entity.right
    end

    return horizontal
end

function PersistenceHelperCorePuffer.selection(room, entity)
    local x, y = entity.x, entity.y
    return utils.rectangle(x-8, y-8, 16, 16)
end

return PersistenceHelperCorePuffer