local monocle = require("#monocle")

local vector2 = require("#microsoft.xna.framework.vector2")

function onBegin(room)
  disableMovement()
  disableRetry()
  player.ForceCameraUpdate = false
  coroutine.yield(getLevel():ZoomTo(vector2(190, 90), 1.25, 1))
  walkTo(5070, false, 1, false)

  say("Ch3_FrustrationPrefall1")
  walkTo(5116, false, 1, false)
  jump(0.2)
  wait(0.4)
  playSound("event:/game/01_forsaken_city/fallblock_ice_shake", player.Position)

  say("Ch3_FrustrationPrefall2")
  walkTo(5060, false, 1, false)
  jump(0.2)
  wait(0.4)
  playSound("event:/game/06_reflection/fallblock_boss_shake", player.Position)
  playSound("event:/game/01_forsaken_city/fallblock_ice_shake", player.Position)

  say("Ch3_FrustrationPrefall3")
  walkTo(5090, false, 1, false)
  jump(0.3)
  wait(0.6)
  playSound("event:/game/06_reflection/fallblock_boss_shake", player.Position)
  playSound("event:/game/01_forsaken_city/fallblock_ice_shake", player.Position)
  playSound("event:/game/general/fallblock_shake", player.Position)

  wait(1)
  say("Ch3_FrustrationPrefall4_Gulp")
  setFlag("donk_FallIntoPit_IcePlanet", true)

  playSound("event:/game/01_forsaken_city/fallblock_ice_shake", player.Position)
  playSound("event:/game/06_reflection/fall_spike_smash", player.Position)
  playSound("event:/game/general/wall_break_ice", player.Position)

  wait(10)
  enableMovement()
end

function onEnd(room, wasSkipped)
  enableMovement()
  player.DummyAutoAnimate = true
  player.ForceCameraUpdate = true
  setFlag("donk_FallIntoPit_IcePlanetSkip", true)
  getLevel():ResetZoom()
  enableMovement()
end