local monocle = require("#monocle")

local vector2 = require("#microsoft.xna.framework.vector2")

function onBegin(room)
  disableMovement()
  disableRetry()
  player.ForceCameraUpdate = true
  player.DummyAutoAnimate = false
  player.Sprite:Play("sitDown", false)
  coroutine.yield(getLevel():ZoomTo(vector2(180, 120), 1.6, 0.5))
  wait(1.5)
  setFlag("donk_IcePlanet_Dark", true)

  engine.Scene:NextColorGrade("Donker19/LackOfInsiration/Dark")
  wait(2)

  playSound("event:/Donk_OrionsBelt/sfx_RingRingRing", player.Position)
  wait(2)
  say("Ch3_RingRingRing_Donk")
  wait(1)

  engine.Scene:NextColorGrade("Donker19/LackOfInsiration/A_HighContrastBrightness")
  setFlag("donk_IcePlanet_Dark", false)

  playSound("event:/Donk_OrionsBelt/sfx_RingRingRing", player.Position)
  wait(1)

  say("Ch3_RingRingRing_Donk2")
  playSound("event:/Donk_OrionsBelt/sfx_RingRingRing", player.Position)
  wait(1)
  player.DummyAutoAnimate = true

  walkTo(9430, false, 0.5, false)
  say("Ch3_RingRingRing_Donk3")
  setFlag("donk_RingRingRing_PhoneCh3", true)
  playSound("event:/char/madeline/crystaltheo_throw", player.Position)
  setFlag("donk_RingRingRing_PhoneCh1", false)
  coroutine.yield(engine.Scene:ZoomBack(1))
  enableMovement()
end

function onEnd(room, wasSkipped)
  enableMovement()
  engine.Scene:NextColorGrade("Donker19/LackOfInsiration/A_HighContrastBrightness")
  setFlag("donk_IcePlanet_Dark", false)
  setFlag("donk_RingRingRing_PhoneCh3", true)
  setFlag("donk_RingRingRing_PhoneCh1", false)
  player.DummyAutoAnimate = true
  player.ForceCameraUpdate = true
  getLevel():ResetZoom()
  enableMovement()
end