#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float3 color = SAMPLE_TEXTURE(text, uv).rgb;

    float dir = 0;
    float3 sampled = color;
    float2 samplepos = uv;
    float dist = 1;
    float strength = 1;
    for (int i = 0; i < 12; i++){
        for (int i = 0; i < 6; i++){
            samplepos = float2(uv.x + (sin(dir) * 0.001 * dist),uv.y + (cos(dir) * 0.003 * dist));
            sampled = SAMPLE_TEXTURE(text, samplepos).rgb;
            if (sampled.r == 1 && sampled.g == 0 && sampled.b == 0){
                color.r += 0.04 * strength;
            }
            dir += 360 / 12;
        }
        dist += 1;
        strength /= 1.1;
    }

    return float4(color,1.0);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}