#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float rand(float2 co) {
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + (CamPos / 2);
    float2 worldPos2 = (uv * Dimensions) + CamPos;
    float4 color = SAMPLE_TEXTURE(text, uv);

    color.rgb *= 1.1;

    float4 sampled = color;
    float2 samplepos = uv;
    float dist = 1;
    float strength = 1.1;

    for (int i = 0; i < 24; i++){
        samplepos = ((uv - 0.5) / dist) + 0.5;
        sampled = SAMPLE_TEXTURE(text, samplepos);
        if (sampled.r + sampled.g + sampled.b > 1.6){
            color += 0.021 * strength;
        }
        strength /= 1.12;
        dist += 0.04;
    }

    color.rg *= (uv.y / 2) + 0.75;

    color.g += uv.y / 4.5;

    color *= ((uv.y * uv.y) + 0.5) / 2;

    dist = 1;
    strength = 1;

    for (int i = 0; i < 24; i++){
        samplepos = ((uv - 0.5) / dist) + 0.5;
        sampled = SAMPLE_TEXTURE(text, samplepos);
        if (sampled.r + sampled.g + sampled.b > 1.6){
            color += 0.021 * strength;
        }
        strength /= 1.12;
        dist += 0.01;
    }

    dist = 1;
    float dir = 0;
    for (int i = 0; i < 40; i++){
        for (int i = 0; i < 12; i++){
            samplepos = float2(uv.x + (sin(dir) * 0.005 * dist),uv.y + (cos(dir) * 0.005 * dist));
            sampled = SAMPLE_TEXTURE(text, samplepos);
            if (sampled.r + sampled.g + sampled.b > 1.6){
                color += 0.0014;
            }
            dir += 360 / 12;
        }
        dist += 0.5;
    }

    float sine_mess = (sin((Time / 2.5) + (worldPos.x / 40)) * 0.03);
    sine_mess += (sin((Time / 3.15) + (worldPos.x / 73)) * 0.03);
    sine_mess += (sin((Time / 7.75) + (worldPos.x / 50)) * 0.03);
    sine_mess += (rand(worldPos2)) * 0.05;
    if (sine_mess + uv.y > 0.95 || sine_mess + uv.y < 0.05){
        color += 0.3;
        color /= 1.1;
    }

    float2 centerpos = uv - 0.5;
    float newpos = (centerpos.x * centerpos.x) + ((centerpos.y * centerpos.y) / 2.8);
    newpos -= rand(uv) / 10;

    if (newpos > 0.04){
        color += 0.04;
        color /= 1.01;
    }

    newpos = (centerpos.x * centerpos.x) + ((centerpos.y * centerpos.y) / 2.8);
    newpos -= rand(uv) / 20;

    if (newpos > 0.04){
        color += 0.04;
        color /= 1.01;
    }

    return color;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}