#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float noise(float2 p){
    float n = dot(p, float2(127.1, 311.7));
    return frac(sin(n) * 43758.5453);
}

float smoothNoise(float2 p){
    float2 i = floor(p);
    float2 f = frac(p);
    float2 u = f * f * (3.0 - 2.0 * f);

    float n00 = noise(i);
    float n10 = noise(i + float2(1.0, 0.0));
    float n01 = noise(i + float2(0.0, 1.0));
    float n11 = noise(i + float2(1.0, 1.0));

    float x1 = lerp(n00, n10, u.x);
    float x2 = lerp(n01, n11, u.x);
    return lerp(x1, x2, u.y);
}

float fbm(float2 p){
    float total = 0.0;
    float amplitude = 0.5;
    float frequency = 1.0;

    [unroll]
    for (int i = 0; i < 2; i++)
    {
        total += amplitude * smoothNoise(p * frequency);
        frequency *= 2.0;
        amplitude *= 0.5;
    }

    return total;
}

float rand(float2 co) {
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + (CamPos / 3);
    float3 color = float3(0,0,0);

    float2 rand_uv = uv + (rand(uv) / 70);
    rand_uv.y += sin((Time + (uv.y * 2)) * 1.2) / 10;

    float n1 = fbm(rand_uv * 4 + (Time / 3));
    float n2 = fbm(float2(rand_uv.y - 100,rand_uv.x - 100) * 4 + (Time / 6.5));

    color += n1 / 2;
    color += n2 / 2;

    if (n1 + n2 > 0.8 && n1 + n2 < 0.9){
        color = float3(0.4,0.2,0.2);
    }
    if (n1 + n2 > 1){
        color = float3(1,1,1);
    }

    color = floor(color * 12) / 12;

    if (n1 + n2 > 1.1){
        color = float3(1,0,0);
    } else {
        color /= 2;
        float brightness = (color.r + color.g + color.b) / 3;
        color = lerp(color,color / brightness,0.3 + (sin(Time + (uv.x + uv.y * 4)) / 5));
        color /= 2;
    }

    float2 layeruv = float2(worldPos.x / 400,(worldPos.y / 300) + (sin(Time + (uv.y * 6)) / 20));
    float layer = fbm((layeruv + (Time / 20)) * 7); // haha 67

    if (layer > 0.2 && layer < 0.3){
        color += 0.05;
    }

    return float4(color,SAMPLE_TEXTURE(text, uv).a);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}