module ChronoHelperLavaSwitch

using ..Ahorn, Maple

@mapdef Entity "ChronoHelper/LavaSwitch" LavaSwitch(x::Integer, y::Integer, time::Number=1.0, distance::Number=20.0, stopAllMovement::Bool=false)

const placements = Ahorn.PlacementDict(
    "Lava Switch (Vertical) (Chrono Helper)" => Ahorn.EntityPlacement(
        LavaSwitch,
        "point",
        Dict{String, Any}(
            "horizontal" => false
        )
    ),
    "Lava Switch (Horizontal) (Chrono Helper)" => Ahorn.EntityPlacement(
        LavaSwitch,
        "point",
        Dict{String, Any}(
            "horizontal" => true
        )
    ),
)
Ahorn.nodeLimits(entity::LavaSwitch) = 0, -1

sprite = "objects/chronohelper/lavaSwitch/switch_0.png"

function Ahorn.selection(entity::LavaSwitch)
    nodes = get(entity.data, "nodes", ())
    x, y = Ahorn.position(entity)

    res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(sprite, x, y)]
    
    for node in nodes
        nx, ny = Int.(node)

        push!(res, Ahorn.getSpriteRectangle(sprite, nx, ny))
    end

    return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::LavaSwitch)
    px, py = Ahorn.position(entity)

    for node in get(entity.data, "nodes", [])
        nx, ny = Int.(node)

        Ahorn.drawArrow(ctx, px, py, nx, ny - 8, Ahorn.colors.selection_selected_fc, headLength=6)
        Ahorn.drawSprite(ctx, sprite, nx, ny)

    end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::LavaSwitch, room::Maple.Room)
    Ahorn.drawSprite(ctx, sprite, 0, 0)
end
end