local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()
local coroutineEntity2 = monocle.Entity()--2

local waitZoomIn
local waitZoomOut
local finishZoomIn = false
local finishZoomOut = false
local function waitTilZoomIn()
    wait(30)
    finishZoomIn = true
end
local function waitTilZoomOut()
    wait(12)
    finishZoomOut = true
end

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end


function onTalk()
    disableMovement()
    playSound("event:/game/02_old_site/sequence_phone_pickup")
    local level = getLevel()
    level:add(coroutineEntity)
    level:add(coroutineEntity2)
    wait(0.2)
    say("dream_calling")
    setFlag("headache1_player_up", true)
    playMusic("music_oldsite_evil_maddy")
    coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(32264, -7375), 15)))
    coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(90, 90), 13.4, 30)))
    waitZoomIn = makeCoroutine(waitTilZoomIn)
    coroutineEntity:add(waitZoomIn)
    say("dream_thinking")
    while not finishZoomIn do
        wait(1)
    end
    setFlag("house_appear",true)
    coroutineEntity2:add(monocle.Coroutine(level:ZoomTo(vector2(90,90), 1, 10)))
    coroutineEntity2:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(32208, -7400), 12)))
    waitZoomOut = makeCoroutine(waitTilZoomOut)
    coroutineEntity2:add(waitZoomOut)
    say("dream_falling")
    while not finishZoomOut do
        wait(1)
    end
    setFlag("house_move", true)
    playSound("event:/game/06_reflection/badeline_pull_impact")
    wait(2)
end


function onEnd()
    if waitZoomIn then
        waitZoomIn:Cancel()
        coroutineEntity:Remove(waitZoomIn)
    end
    if waitZoomOut then
        waitZoomOut:Cancel()
        coroutineEntity2:Remove(waitZoomOut)
    end
    teleportTo(30, 30, "b-outside", "None")
    enableMovement()
    setFlag("headache1_player_up", false)
    setFlag("house_appear", false)
    setFlag("house_move", false)
end
