-- store the badeline entity outside the functions, so it can be accessed whenever necessary
local badeline = nil

-- Get Monocle so we can use it
local monocle = require("#monocle")
-- Store an instance of a Monocle entity
local coroutineEntity = monocle.Entity()

local function badeline_appears(left_side)
  -- determine the position and flipping properties
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 8

  -- create and add a new badeline dummy entity
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  -- play sound + effect
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  -- wait until the next frame so all that can take effect properly
  wait()
end

local function badeline_vanishes()
  -- tell the badeline entity to disappear
  badeline:Vanish()
  celeste.Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  -- clear the stored variable so the memory can be used for something else
  badeline = nil

  -- wait until the next frame
  wait()
end

function onBegin()
    makeUnskippable()
    disableRetry()
    disableMovement()
    waitUntilOnGround ()
    setFlag("darkout",true)
    player.DummyAutoAnimate = false
    player.Sprite:Play("tired")
    setFlag("darkout",true)
    wait(2)
    badeline_appears()
    wait(2)
    say("LDSS_Chelito_TheTalk1")
    result = choice("LDSS_Chelito_ChoiceListen","LDSS_Chelito_ChoiceIgnore")
    if result == 1 then
      playMusic("event:/LDSS/TheTalk")
      setFlag("FullCrackOut",true)
      say("LDSS_Chelito_ChoiceListen_SAY1")
      player.Sprite:Play("wakeUp")
      say("LDSS_Chelito_ChoiceListen_SAY2")
      wait(1)
      say("LDSS_Chelito_ChoiceListen_SAY3")
    elseif result == 2 then 
      say("LDSS_Chelito_ChoiceIgnore_SAY")
      setFlag("ending2", true)
      setFlag("darkout",false)
      setFlag("dark",true)
    end
    badeline_vanishes()
    if result == 1 then
      setFlag("free",true)
    end
    jump(1)
  end
  
  function onEnd()
    enableRetry()
    enableMovement()
  end