local rotations = {
    Forward = "hoopforward",
    Rotated = "hooprotated",
    Sideways = "hoopsideways",
}

local entity_version = 0

local hoop = {
    name = "Frigohelper/Hoop",
    justification = {0.5,0.5},
    fieldInformation = {
        rotation = {
            options = rotations,
            editable = false,
        }
    },
    placements = {
        {
            name = "hoopforward",
            data = {
                version = entity_version,
                rotation = "hoopforward",
                flipX = false,
            },
        },
        {
            name = "hooprotatedright",
            data = {
                version = entity_version,
                rotation = "hooprotated",
                flipX = true,
            },
        },
        {
            name = "hooprotatedleft",
            data = {
                version = entity_version,
                rotation = "hooprotated",
                flipX = false,
            },
        },
        {
            name = "hoopsidewaysright",
            data = {
                version = entity_version,
                rotation = "hoopsideways",
                flipX = true,
            },
        },
        {
            name = "hoopsidewaysleft",
            data = {
                version = entity_version,
                rotation = "hoopsideways",
                flipX = false,
            },
        },
    },
    ignoredFields = {
        "_name", "_id", "originX", "originY",
        "version",
    },
    texture = function(room, entity)
        return "objects/FrigoHelper/hoop/"..entity.rotation.."full00"
    end,
    depth = function(room, entity)
        return entity.rotation == "hoopsidewaysfull00" and -10501 or 2006
    end,
    scale = function(room, entity)
        return { entity.flipX and -1 or 1, 1 }
    end
}

return hoop