local drawableSpriteStruct = require("structs.drawable_sprite")
local rotateSpinner = {}

local nodeAlpha = 0.3
local dustEdgeColor = {1.0, 0.0, 0.0}

rotateSpinner.name = "IsaSMB/RotateSpinner"
rotateSpinner.nodeLimits = {1, 1000}
rotateSpinner.nodeLineRenderType = "circle"
rotateSpinner.depth = -50
rotateSpinner.placements = {
    {
        name = "default",
        data = {
            clockwise = true,
            cycle = "base",
            sprite = "blade",
            localSpeed = 1,
        }
    },
    {
        name = "dust",
        data = {
            clockwise = true,
            cycle = "base",
            sprite = "dust",
            localSpeed = 1,
        }
    },
    {
        name = "star",
        data = {
            clockwise = true,
            cycle = "base",
            sprite = "star",
            localSpeed = 1,
        }
    }
}
rotateSpinner.fieldInformation = {
    sprite = {
        options = {
            "blade",
            "dust",
            "star"
        }
    }
}

local function getSprite(room, entity, alpha)
    local sprites = {}

    local spriteID = entity.sprite

    if spriteID == "star" then
        local starfishTexture = "danger/starfish13"

        table.insert(sprites, drawableSpriteStruct.fromTexture(starfishTexture, entity))

    elseif spriteID == "dust" then
        local dustBaseTexture = "danger/dustcreature/base00"
        local dustBaseOutlineTexture = "dust_creature_outlines/base00"
        local dustBaseSprite = drawableSpriteStruct.fromTexture(dustBaseTexture, entity)
        local dustBaseOutlineSprite = drawableSpriteStruct.fromInternalTexture(dustBaseOutlineTexture, entity)

        dustBaseOutlineSprite:setColor(dustEdgeColor)

        table.insert(sprites, dustBaseOutlineSprite)
        table.insert(sprites, dustBaseSprite)

    else
        local bladeTexture = "danger/blade00"

        table.insert(sprites, drawableSpriteStruct.fromTexture(bladeTexture, entity))
    end

    if alpha then
        for _, sprite in ipairs(sprites) do
            sprite:setAlpha(alpha)
        end
    end

    return sprites
end

function rotateSpinner.sprite(room, entity)
    return getSprite(room, entity)
end

function rotateSpinner.nodeSprite(room, entity, node)
    local entityCopy = table.shallowcopy(entity)

    entityCopy.x = node.x
    entityCopy.y = node.y

    return getSprite(room, entityCopy, nodeAlpha)
end

return rotateSpinner