local utils = require("utils")
local fakeTilesHelper = require("helpers.fake_tiles")

local movingBlock = {}

movingBlock.name = "IsaSMB/CycleBlock"
movingBlock.depth = 0
movingBlock.nodeLineRenderType = "line"
movingBlock.nodeLimits = {1, 100}
movingBlock.placements = {
    name = "default",
    data = {
        tileType = fakeTilesHelper.getPlacementMaterial(),
        width = 8,
        height = 8,
        cycle = "base",
        offset = 0,
        moveTime = 0.9,
        stopTime = 0.1,
        localSpeed = 1,
        looped = false,
    }
}
movingBlock.fieldInformation = fakeTilesHelper.getFieldInformation("tileType")
--[[
movingBlock.fieldInformation.nodeIndex = {}
movingBlock.fieldInformation.nodeIndex = {
    fieldType = "integer"
}
]]


movingBlock.sprite = fakeTilesHelper.getEntitySpriteFunction("tileType", false)
movingBlock.nodeSprite = fakeTilesHelper.getEntitySpriteFunction("tileType", false)

function movingBlock.nodeRectangle(room, entity, node)
    return utils.rectangle(node.x or 0, node.y or 0, entity.width or 8, entity.height or 8)
end

return movingBlock