local drawableSprite = require("structs.drawable_sprite")

local matrixPanel = {}
matrixPanel.name = "EvaHelper/PortalMatrixPanelLangton"
matrixPanel.depth = 0
matrixPanel.placements = {
	{
		name = "Matrix Panel Langton Ant (yellow)",
		data = {
			width = 48,
			height = 32,
			cols = 8,
			rows = 2,
			text = "   STEPS",
			spinType = "Random",
			colorBackground = "000000",
			colorBorder = "FFA500",
			colorDigits = "101000",
			colorText = "FFFF00",
			spinPeriod = 0.06,
			blinkCount = 3,
			blinkPeriod = 0.3,
			depth = 9999999,
			signalsGet = "",
			langtonParam = "steps",
			paddingChar = "0"
		}
	}
}

matrixPanel.fieldInformation = {
	spinType = {
		options = { "Immediately", "Alphabet", "Random" }
	},
	langtonParam = {
		options = { "steps", "speed" }
	},
	colorBackground = { fieldType = "color" },
	colorBorder = { fieldType = "color" },
	colorDigits = { fieldType = "color" },
	colorText = { fieldType = "color" },
	cols = { fieldType = "integer", minimumValue = 1 },
	rows = { fieldType = "integer", minimumValue = 1 },
}

matrixPanel.fieldOrder = { "x", "y", "width", "height", "cols", "rows", "text", "spinType", "colorBackground", "colorBorder", "colorDigits", "colorText",  "spinPeriod", "blinkCount", "blinkPeriod", "signalsGet", "langtonParam", "paddingChar", "depth" }


function matrixPanel.draw(room, entity)
	local r, g, b, a = love.graphics.getColor()
	
	love.graphics.setColor(0.0, 0.0, 0.0, 1.0)
	love.graphics.rectangle("fill", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	love.graphics.setColor(0.0, 1.0, 0.0, 1.0)
	love.graphics.rectangle("line", entity.x + 2.5, entity.y + 2.5, entity.width - 5, entity.height - 5)
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
		
	-- sprite draw
	local entitySprite = drawableSprite.fromTexture("Evidence02/objects_eva/ahorn/textmessage")
	entitySprite.x = entity.x + entity.width / 2
	entitySprite.y = entity.y + entity.height / 2
	entitySprite:draw()
end

return matrixPanel
