local drawableSprite = require("structs.drawable_sprite")

local matrixPanel = {}
matrixPanel.name = "EvaHelper/PortalMatrixPanel"
matrixPanel.depth = 0
matrixPanel.placements = {
	{
		name = "Matrix Panel (green)",
		data = {
			width = 48,
			height = 32,
			cols = 6,
			rows = 2,
			text = "Points",
			spinType = "Random",
			colorBackground = "404040",
			colorBorder = "00FF21",
			colorDigits = "004F26",
			colorText = "00FF21",
			spinPeriod = 0.06,
			blinkCount = 3,
			blinkPeriod = 0.3,
			depth = 9999999,
			signalsGet = ""
		}
	},
	{
		name = "Matrix Panel (red)",
		data = {
			width = 48,
			height = 32,
			cols = 6,
			rows = 2,
			text = "Points",
			spinType = "Random",
			colorBackground = "000000",
			colorBorder = "FF2100",
			colorDigits = "1A0000",
			colorText = "FF2100",
			spinPeriod = 0.06,
			blinkCount = 3,
			blinkPeriod = 0.3,
			depth = 9999999,
			signalsGet = ""
		}
	}
}

matrixPanel.fieldInformation = {
	spinType = {
		options = { "Immediately", "Alphabet", "Random" }
	},
	colorBackground = { fieldType = "color" },
	colorBorder = { fieldType = "color" },
	colorDigits = { fieldType = "color" },
	colorText = { fieldType = "color" },
	cols = { fieldType = "integer", minimumValue = 1 },
	rows = { fieldType = "integer", minimumValue = 1 },
}

matrixPanel.fieldOrder = { "x", "y", "width", "height", "cols", "rows", "text", "spinType", "colorBackground", "colorBorder", "colorDigits", "colorText",  "spinPeriod", "blinkCount", "blinkPeriod", "signalsGet", "depth" }

function matrixPanel.draw(room, entity)
	local r, g, b, a = love.graphics.getColor()
	
	love.graphics.setColor(0.0, 0.0, 0.0, 1.0)
	love.graphics.rectangle("fill", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	love.graphics.setColor(0.0, 1.0, 0.0, 1.0)
	love.graphics.rectangle("line", entity.x + 2.5, entity.y + 2.5, entity.width - 5, entity.height - 5)
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
		
	-- sprite draw
	local entitySprite = drawableSprite.fromTexture("Evidence02/objects_eva/ahorn/textmessage")
	entitySprite.x = entity.x + entity.width / 2
	entitySprite.y = entity.y + entity.height / 2
	entitySprite:draw()
end

return matrixPanel
