local drawableSprite = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")

local multiplyPlayer = {}
multiplyPlayer.name = "EvaHelper/MultiplyPlayer"
multiplyPlayer.depth = 0
multiplyPlayer.placements = {
	{
		name = "Multiply Player (2 players)",
		data = {
			countPlayers = 2,
			startPlayer = 0,
			moveDuration = 0.36,
			positionList = "-24,0,M,R;24,0,B,L",
			active = true,
			showArrow = true,
			showNumbers = true
		}
	},
	{
		name = "Multiply Player (3 players)",
		data = {
			countPlayers = 3,
			startPlayer = 0,
			moveDuration = 0.36,
			positionList = "-24,0,M,R;0,-24,B,R;24,0,B,L",
			active = true,
			showArrow = true,
			showNumbers = true
		}
	}
}

multiplyPlayer.fieldInformation = {
	countPlayers = { fieldType = "integer", minimumValue = 1 },
	startPlayer = { fieldType = "integer", minimumValue = 0 },
}

function multiplyPlayer.selection(room, entity)
	local x, y = entity.x or 0, entity.y or 0
	return utils.rectangle(x - 8, y - 8, 16, 16)
end

function multiplyPlayer.draw(room, entity)
	local ex, ey, poslist = entity.x or 0, entity.y or 0, entity.positionList or ""
	local r, g, b, a = love.graphics.getColor()
	
	
	local num = 1
	for row in string.gmatch(poslist, "[^;]+") do
		local x, y, spriteModeMaddy = ex, ey, "M"
		
		-- parse row '-24,0,M,R'
		local pos = 0
		for s in string.gmatch(row, "[^,]+") do
			if	 pos == 0 then x = ex + tonumber(s)
			elseif pos == 1 then y = ey + tonumber(s)
			elseif pos == 2 then spriteModeMaddy = s
			----elseif pos = 3 then left = s
			end
			pos = pos + 1
		end
		
		
		-- draw rect and line with certain color
		if string.sub(string.upper(spriteModeMaddy), 1, 1) ~= 'B' 
			then love.graphics.setColor(1.0, 0.5, 0.0, 0.6)
			else love.graphics.setColor(1.0, 0.0, 1.0, 0.6)
		end
		
		love.graphics.rectangle("fill", x - 2, y - 2, 4, 4)
		love.graphics.line(ex, ey, x, y)
		
		-- additional text
		local font = love.graphics.getFont()
		local textBatch = love.graphics.newText(font)
		drawing.callKeepOriginalColor(function()
			love.graphics.setColor(1.0, 1.0, 1.0, 1.0)
			drawing.printCenteredText(tostring(num), x, y - 8, 20, 12, font, 1)
		end)
		love.graphics.draw(textBatch)
		
		num = num + 1
	end
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
	
	
	-- sprite draw
	local entitySprite = drawableSprite.fromTexture("Evidence02/objects_eva/ahorn/multiply_player")
	entitySprite.x = ex
	entitySprite.y = ey
	entitySprite:draw()
end

return multiplyPlayer
