local drawableSprite = require("structs.drawable_sprite")

local langtonSpeedBlock = {}
langtonSpeedBlock.name = "EvaHelper/LangtonSpeedBlock"
langtonSpeedBlock.depth = 0
langtonSpeedBlock.placements = {
    {
        name = "Langton Speed Block",
        data = {
			width = 16,
			height = 16,
			texture = "",
			listSpeeds = "2,5,10,15,20,30,50,75,100,200,500,1000",
			increase = true
        }
    }
}

function langtonSpeedBlock.draw(room, entity)
	
    local r, g, b, a = love.graphics.getColor()
    	
	love.graphics.setColor(0.0, 0.0, 0.0, 1.0)
    love.graphics.rectangle("fill", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	love.graphics.setColor(0.5, 0.5, 0.5, 1.0)
    love.graphics.rectangle("line", entity.x + 2.5, entity.y + 2.5, entity.width - 5, entity.height - 5)
	
    -- reset color
    love.graphics.setColor(r, g, b, a)
end

return langtonSpeedBlock
