local drawableSprite = require("structs.drawable_sprite")

local langtonLengthBlock = {}
langtonLengthBlock.name = "EvaHelper/LangtonLengthBlock"
langtonLengthBlock.depth = 0
langtonLengthBlock.placements = {
	{
		name = "Langton Length Block",
		data = {
			width = 16,
			height = 16,
			color = "FFFFFF"
		}
	}
}

langtonLengthBlock.fieldInformation = {
	color = { fieldType = "color" }
}

function langtonLengthBlock.draw(room, entity)
	
	local r, g, b, a = love.graphics.getColor()
		
	love.graphics.setColor(0.0, 0.0, 0.0, 1.0)
	love.graphics.rectangle("fill", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	love.graphics.setColor(0.5, 0.5, 0.5, 1.0)
	love.graphics.rectangle("line", entity.x + 2.5, entity.y + 2.5, entity.width - 5, entity.height - 5)
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
end

return langtonLengthBlock
