local jautils = require("mods").requireFromPlugin("libraries.jautils")
local utils = require("utils")

local helpyRobot = {}
helpyRobot.name = "EvaHelper/HelpyRobot"
helpyRobot.depth = 0
helpyRobot.placements = {
	{
		name = "Helpy Robot",
		data = {
			width = 16,
			height = 16,
			speedX = 160,
			ballCheckDY = 48,
			colorBorder = "EE82EE",
			colorBattery = "D884D4",
			batterySpeedDecrease = 0.2,
			batterySpeedIncrease = 0.3,
			batteryWaitChargePeriod = 3,
			signalSendOnFinish = ""
			
		}
	}
}

helpyRobot.fieldOrder = { "x", "y", "width", "height", "speedX", "ballCheckDY", "colorBorder", "colorBattery", "batterySpeedDecrease", "batterySpeedIncrease", "batteryWaitChargePeriod", "signalSendOnFinish" }


helpyRobot.fieldInformation = {
	colorBorder = { fieldType = "color" },
	colorBattery = { fieldType = "color" },
	ballCheckDY = { fieldType = "integer" },
}

function helpyRobot.selection(room, entity)
	return utils.rectangle(entity.x or 0, entity.y or 0, entity.width or 16, entity.height or 16)
end

function helpyRobot.draw(room, entity)
	local r, g, b, a = love.graphics.getColor()
	
	love.graphics.setColor(1.0, 0.0, 1.0, 0.4)
	love.graphics.rectangle("fill", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	love.graphics.setColor(1.0, 0.0, 1.0, 1.0)
	love.graphics.rectangle("line", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
end

return helpyRobot
